/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;

public class DomainObjectReader {
    @NonNull
    private final PersistentEntities entities;
    @NonNull
    private final Associations associationLinks;

    public <T> T read(InputStream source, T target, ObjectMapper mapper) {
        Assert.notNull(target, (String)"Target object must not be null!");
        Assert.notNull((Object)source, (String)"InputStream must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        try {
            return this.doMerge((ObjectNode)mapper.readTree(source), target, mapper);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)o_O);
        }
    }

    public <T> T readPut(final ObjectNode source, T target, ObjectMapper mapper) {
        Assert.notNull((Object)source, (String)"ObjectNode must not be null!");
        Assert.notNull(target, (String)"Existing object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Class<?> type = target.getClass();
        PersistentEntity entity = this.entities.getPersistentEntity(type);
        Assert.notNull((Object)entity, (String)"No PersistentEntity found for ".concat(type.getName()).concat("!"));
        final MappedProperties properties = MappedProperties.fromJacksonProperties(entity, mapper);
        entity.doWithProperties(new SimplePropertyHandler(){

            public void doWithPersistentProperty(PersistentProperty<?> property) {
                boolean noValueInSource;
                if (property.isIdProperty() || property.isVersionProperty() || !property.isWritable()) {
                    return;
                }
                String mappedName = properties.getMappedName(property);
                boolean isMappedProperty = mappedName != null;
                boolean bl = noValueInSource = !source.has(mappedName);
                if (isMappedProperty && noValueInSource) {
                    source.putNull(mappedName);
                }
            }
        });
        return this.merge(source, target, mapper);
    }

    public <T> T merge(ObjectNode source, T target, ObjectMapper mapper) {
        try {
            return this.doMerge(source, target, mapper);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)o_O);
        }
    }

    private <T> T doMerge(ObjectNode root, T target, ObjectMapper mapper) throws Exception {
        Assert.notNull((Object)root, (String)"Root ObjectNode must not be null!");
        Assert.notNull(target, (String)"Target object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        PersistentEntity entity = this.entities.getPersistentEntity(target.getClass());
        if (entity == null) {
            return (T)mapper.readerForUpdating(target).readValue((JsonNode)root);
        }
        MappedProperties mappedProperties = MappedProperties.fromJacksonProperties(entity, mapper);
        Iterator i = root.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            JsonNode child = (JsonNode)entry.getValue();
            String fieldName = (String)entry.getKey();
            if (!mappedProperties.hasPersistentPropertyForField(fieldName)) {
                i.remove();
                continue;
            }
            PersistentProperty<?> property = mappedProperties.getPersistentProperty(fieldName);
            PersistentPropertyAccessor accessor = entity.getPropertyAccessor(target);
            Object rawValue = accessor.getProperty(property);
            if (child.isArray()) {
                boolean nestedObjectFound = this.handleArrayNode((ArrayNode)child, DomainObjectReader.asCollection(rawValue), mapper);
                if (!nestedObjectFound) continue;
                i.remove();
                continue;
            }
            if (!child.isObject() || this.associationLinks.isLinkableAssociation(property)) continue;
            ObjectNode objectNode = (ObjectNode)child;
            if (property.isMap()) {
                if (!objectNode.fieldNames().hasNext()) continue;
                this.doMergeNestedMap((Map)rawValue, objectNode, mapper);
                if (objectNode.fieldNames().hasNext()) continue;
                i.remove();
                continue;
            }
            if (rawValue == null || !property.isEntity()) continue;
            this.doMerge(objectNode, rawValue, mapper);
        }
        return (T)mapper.readerForUpdating(target).readValue((JsonNode)root);
    }

    private boolean handleArrayNode(ArrayNode array, Collection<Object> collection, ObjectMapper mapper) throws Exception {
        Assert.notNull((Object)array, (String)"ArrayNode must not be null!");
        Assert.notNull(collection, (String)"Source collection must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Iterator<Object> value = collection.iterator();
        boolean nestedObjectFound = false;
        for (JsonNode jsonNode : array) {
            if (!value.hasNext()) {
                return nestedObjectFound;
            }
            Object next = value.next();
            if (ArrayNode.class.isInstance(jsonNode)) {
                return this.handleArrayNode(array, DomainObjectReader.asCollection(next), mapper);
            }
            if (!ObjectNode.class.isInstance(jsonNode)) continue;
            nestedObjectFound = true;
            this.doMerge((ObjectNode)jsonNode, next, mapper);
        }
        return nestedObjectFound;
    }

    private void doMergeNestedMap(Map<String, Object> source, ObjectNode node, ObjectMapper mapper) throws Exception {
        if (source == null) {
            return;
        }
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            JsonNode child = (JsonNode)entry.getValue();
            Object sourceValue = source.get(entry.getKey());
            if (child instanceof ObjectNode && sourceValue != null) {
                this.doMerge((ObjectNode)child, sourceValue, mapper);
            } else if (child instanceof ArrayNode && sourceValue != null) {
                this.handleArrayNode((ArrayNode)child, DomainObjectReader.asCollection(sourceValue), mapper);
            } else {
                source.put((String)entry.getKey(), mapper.treeToValue((TreeNode)child, sourceValue == null ? Object.class : sourceValue.getClass()));
            }
            fields.remove();
        }
    }

    private static Collection<Object> asCollection(Object source) {
        if (source == null) {
            return Collections.emptyList();
        }
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source.getClass().isArray()) {
            return Arrays.asList((Object[])source);
        }
        return Collections.singleton(source);
    }

    @ConstructorProperties(value={"entities", "associationLinks"})
    public DomainObjectReader(@NonNull PersistentEntities entities, @NonNull Associations associationLinks) {
        if (entities == null) {
            throw new IllegalArgumentException("entities is null");
        }
        if (associationLinks == null) {
            throw new IllegalArgumentException("associationLinks is null");
        }
        this.entities = entities;
        this.associationLinks = associationLinks;
    }

    static class MappedProperties {
        private static final ClassIntrospector INTROSPECTOR = new BasicClassIntrospector();
        private final Map<PersistentProperty<?>, String> propertyToFieldName;
        private final Map<String, PersistentProperty<?>> fieldNameToProperty;

        private MappedProperties(PersistentEntity<?, ?> entity, BeanDescription description) {
            Assert.notNull(entity, (String)"Entity must not be null!");
            Assert.notNull((Object)description, (String)"BeanDescription must not be null!");
            this.propertyToFieldName = new HashMap();
            this.fieldNameToProperty = new HashMap();
            for (BeanPropertyDefinition property : description.findProperties()) {
                PersistentProperty persistentProperty = entity.getPersistentProperty(property.getInternalName());
                if (persistentProperty == null) continue;
                this.propertyToFieldName.put(persistentProperty, property.getName());
                this.fieldNameToProperty.put(property.getName(), persistentProperty);
            }
        }

        public static MappedProperties fromJacksonProperties(PersistentEntity<?, ?> entity, ObjectMapper mapper) {
            BeanDescription description = INTROSPECTOR.forDeserialization(mapper.getDeserializationConfig(), mapper.constructType((Type)entity.getType()), (ClassIntrospector.MixInResolver)mapper.getDeserializationConfig());
            return new MappedProperties(entity, description);
        }

        public String getMappedName(PersistentProperty<?> property) {
            Assert.notNull(property, (String)"PersistentProperty must not be null!");
            return this.propertyToFieldName.get(property);
        }

        public boolean hasPersistentPropertyForField(String fieldName) {
            Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
            return this.fieldNameToProperty.containsKey(fieldName);
        }

        public PersistentProperty<?> getPersistentProperty(String fieldName) {
            Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
            return this.fieldNameToProperty.get(fieldName);
        }
    }
}

