/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.hateoas.Link;
import org.springframework.util.Assert;

public class Associations {
    @NonNull
    private final ResourceMappings mappings;
    @NonNull
    private final RepositoryRestConfiguration config;

    public List<Link> getLinksFor(Association<? extends PersistentProperty<?>> association, Path path) {
        Assert.notNull(association, (String)"Association must not be null!");
        Assert.notNull((Object)path, (String)"Base path must not be null!");
        if (this.isLinkableAssociation(association)) {
            PersistentProperty property = association.getInverse();
            ResourceMetadata metadata = this.mappings.getMetadataFor(property.getOwner().getType());
            ResourceMapping propertyMapping = metadata.getMappingFor(property);
            String href = path.slash(propertyMapping.getPath()).toString();
            String rel = propertyMapping.getRel();
            return Collections.singletonList(new Link(href, rel));
        }
        return Collections.emptyList();
    }

    public ResourceMetadata getMetadataFor(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return this.mappings.getMetadataFor(type);
    }

    public boolean isLookupType(PersistentProperty<?> property) {
        return property == null ? false : this.config.isLookupType(property.getActualType());
    }

    public boolean isIdExposed(PersistentEntity<?, ?> entity) {
        return this.config.isIdExposedFor(entity.getType());
    }

    public boolean isLinkableAssociation(Association<? extends PersistentProperty<?>> association) {
        Assert.notNull(association, (String)"Association must not be null!");
        return this.isLinkableAssociation(association.getInverse());
    }

    public boolean isLinkableAssociation(PersistentProperty<?> property) {
        if (property == null || !property.isAssociation() || this.config.isLookupType(property.getActualType())) {
            return false;
        }
        ResourceMetadata metadata = this.mappings.getMetadataFor(property.getOwner().getType());
        if (metadata != null && !metadata.isExported(property)) {
            return false;
        }
        metadata = this.mappings.getMetadataFor(property.getActualType());
        return metadata == null ? false : metadata.isExported();
    }

    public Associations(@NonNull ResourceMappings mappings, @NonNull RepositoryRestConfiguration config) {
        if (mappings == null) {
            throw new IllegalArgumentException("mappings is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.mappings = mappings;
        this.config = config;
    }

    @NonNull
    public ResourceMappings getMappings() {
        return this.mappings;
    }
}

