/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.io.Serializable;
import java.util.ArrayList;
import lombok.NonNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ParameterMetadata;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.PagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.support.RepositoryLinkBuilder;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.core.AbstractEntityLinks;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class RepositoryEntityLinks
extends AbstractEntityLinks {
    @NonNull
    private final Repositories repositories;
    @NonNull
    private final ResourceMappings mappings;
    @NonNull
    private final RepositoryRestConfiguration config;
    @NonNull
    private final PagingAndSortingTemplateVariables templateVariables;
    @NonNull
    private final PluginRegistry<BackendIdConverter, Class<?>> idConverters;

    public boolean supports(Class<?> delimiter) {
        return this.repositories.hasRepositoryFor(delimiter);
    }

    public LinkBuilder linkFor(Class<?> type) {
        ResourceMetadata metadata = this.mappings.getMetadataFor(type);
        return new RepositoryLinkBuilder(metadata, new BaseUri(this.config.getBaseUri()));
    }

    public LinkBuilder linkFor(Class<?> type, Object ... parameters) {
        return this.linkFor(type);
    }

    public Link linkToPagedResource(Class<?> type, Pageable pageable) {
        ResourceMetadata metadata = this.mappings.getMetadataFor(type);
        String href = this.linkFor(type).toString();
        UriComponents components = this.prepareUri(href, (ResourceMapping)metadata, pageable);
        TemplateVariables variables = this.getTemplateVariables(components, (ResourceMapping)metadata, pageable).concat(this.getProjectionVariable(type));
        return new Link(new UriTemplate(href, variables), metadata.getRel());
    }

    public Link linkToCollectionResource(Class<?> type) {
        return this.linkToPagedResource(type, null);
    }

    public Link linkToSingleResource(Class<?> type, Object id) {
        Assert.isInstanceOf(Serializable.class, (Object)id, (String)"Id must be assignable to Serializable!");
        ResourceMetadata metadata = this.mappings.getMetadataFor(type);
        String mappedId = ((BackendIdConverter)this.idConverters.getPluginFor(type, (Plugin)BackendIdConverter.DefaultIdConverter.INSTANCE)).toRequestId((Serializable)id, type);
        Link link = this.linkFor(type).slash((Object)mappedId).withRel(metadata.getItemResourceRel());
        return new Link(new UriTemplate(link.getHref(), this.getProjectionVariable(type)).toString(), metadata.getItemResourceRel());
    }

    public Links linksToSearchResources(Class<?> type) {
        return this.linksToSearchResources(type, null, null);
    }

    public Links linksToSearchResources(Class<?> type, Pageable pageable) {
        return this.linksToSearchResources(type, pageable, null);
    }

    public Links linksToSearchResources(Class<?> type, Sort sort) {
        return this.linksToSearchResources(type, null, sort);
    }

    public Link linkToSearchResource(Class<?> domainType, String rel) {
        return this.getSearchResourceLinkFor(domainType, rel, null, null);
    }

    public Link linkToSearchResource(Class<?> domainType, String rel, Pageable pageable) {
        return this.getSearchResourceLinkFor(domainType, rel, pageable, null);
    }

    public Link linkToSearchResource(Class<?> domainType, String rel, Sort sort) {
        return this.getSearchResourceLinkFor(domainType, rel, null, sort);
    }

    private Links linksToSearchResources(Class<?> type, Pageable pageable, Sort sort) {
        ArrayList<Link> links = new ArrayList<Link>();
        SearchResourceMappings searchMappings = this.mappings.getSearchResourceMappings(type);
        for (MethodResourceMapping mapping : searchMappings.getExportedMappings()) {
            links.add(this.getSearchResourceLinkFor(type, mapping.getRel(), pageable, sort));
        }
        return new Links(links);
    }

    private Link getSearchResourceLinkFor(Class<?> type, String rel, Pageable pageable, Sort sort) {
        Assert.notNull(type, (String)"Domain type must not be null!");
        Assert.hasText((String)rel, (String)"Relation name must not be null or empty!");
        SearchResourceMappings searchMappings = this.mappings.getSearchResourceMappings(type);
        MethodResourceMapping mapping = searchMappings.getExportedMethodMappingForRel(rel);
        if (mapping == null) {
            return null;
        }
        LinkBuilder builder = this.linkFor(type).slash((Object)this.mappings.getSearchResourceMappings(type).getPath()).slash((Object)mapping.getPath());
        UriComponents uriComponents = this.prepareUri(builder.toString(), mapping, pageable, sort);
        TemplateVariables variables = this.getParameterVariables(mapping).concat(this.getTemplateVariables(uriComponents, mapping, pageable, sort)).concat(this.getProjectionVariable(mapping.getReturnedDomainType()));
        return new Link(new UriTemplate(uriComponents.toString(), variables), mapping.getRel());
    }

    private TemplateVariables getTemplateVariables(UriComponents components, ResourceMapping mapping, Pageable pageable) {
        if (mapping.isPagingResource()) {
            return this.templateVariables.getPaginationTemplateVariables(null, components);
        }
        return TemplateVariables.NONE;
    }

    private TemplateVariables getTemplateVariables(UriComponents components, MethodResourceMapping mapping, Pageable pageable, Sort sort) {
        if (mapping.isSortableResource()) {
            return this.templateVariables.getSortTemplateVariables(null, components);
        }
        return this.getTemplateVariables(components, (ResourceMapping)mapping, pageable);
    }

    private TemplateVariables getProjectionVariable(Class<?> type) {
        ProjectionDefinitionConfiguration projectionConfiguration = this.config.getProjectionConfiguration();
        if (projectionConfiguration.hasProjectionFor(type)) {
            return new TemplateVariables(new TemplateVariable[]{new TemplateVariable(projectionConfiguration.getParameterName(), TemplateVariable.VariableType.REQUEST_PARAM)});
        }
        return TemplateVariables.NONE;
    }

    private TemplateVariables getParameterVariables(MethodResourceMapping mapping) {
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        for (ParameterMetadata metadata : mapping.getParametersMetadata()) {
            variables.add(new TemplateVariable(metadata.getName(), TemplateVariable.VariableType.REQUEST_PARAM));
        }
        return new TemplateVariables(variables);
    }

    private UriComponents prepareUri(String uri, MethodResourceMapping mapping, Pageable pageable, Sort sort) {
        if (mapping.isSortableResource()) {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)uri);
            this.templateVariables.enhance(uriBuilder, null, sort);
            return uriBuilder.build();
        }
        return this.prepareUri(uri, (ResourceMapping)mapping, pageable);
    }

    private UriComponents prepareUri(String uri, ResourceMapping mapping, Pageable pageable) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)uri);
        if (mapping.isPagingResource()) {
            this.templateVariables.enhance(uriBuilder, null, pageable);
        }
        return uriBuilder.build();
    }

    public RepositoryEntityLinks(@NonNull Repositories repositories, @NonNull ResourceMappings mappings, @NonNull RepositoryRestConfiguration config, @NonNull PagingAndSortingTemplateVariables templateVariables, @NonNull PluginRegistry<BackendIdConverter, Class<?>> idConverters) {
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
        if (mappings == null) {
            throw new IllegalArgumentException("mappings is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        if (templateVariables == null) {
            throw new IllegalArgumentException("templateVariables is null");
        }
        if (idConverters == null) {
            throw new IllegalArgumentException("idConverters is null");
        }
        this.repositories = repositories;
        this.mappings = mappings;
        this.config = config;
        this.templateVariables = templateVariables;
        this.idConverters = idConverters;
    }
}

