/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.rest.webmvc.json.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.PatchOperation;

class AddOperation
extends PatchOperation {
    public AddOperation(String path, Object value) {
        super("add", path, value);
    }

    @Override
    <T> void perform(Object targetObject, Class<T> type) {
        this.addValue(targetObject, this.evaluateValueFromTarget(targetObject, type));
    }

    @Override
    protected <T> Object evaluateValueFromTarget(Object targetObject, Class<T> entityType) {
        if (!this.path.endsWith("-")) {
            return super.evaluateValueFromTarget(targetObject, entityType);
        }
        String pathSource = Arrays.stream(this.path.split("/")).filter(it -> !it.matches("\\d")).filter(it -> !it.equals("-")).filter(it -> !it.isEmpty()).collect(Collectors.joining("."));
        PropertyPath propertyPath = PropertyPath.from((String)pathSource, entityType);
        return this.value instanceof LateObjectEvaluator ? ((LateObjectEvaluator)this.value).evaluate(propertyPath.getType()) : this.value;
    }
}

