/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.Ordered;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;
import org.springframework.web.util.pattern.PathPatternParser;

class DelegatingHandlerMapping
implements org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping,
Ordered {
    private final List<HandlerMapping> delegates;
    @Nullable
    private final PathPatternParser parser;

    public DelegatingHandlerMapping(List<HandlerMapping> delegates, @Nullable PathPatternParser parser) {
        Assert.notNull(delegates, (String)"Delegates must not be null!");
        this.delegates = delegates;
        this.parser = parser;
    }

    public boolean usesPathPatterns() {
        return this.parser != null;
    }

    @Nullable
    public PathPatternParser getPatternParser() {
        return this.parser;
    }

    @Override
    public List<HandlerMapping> getDelegates() {
        return this.delegates;
    }

    @Override
    public Iterator<HandlerMapping> iterator() {
        return this.delegates.iterator();
    }

    public int getOrder() {
        return 2147483547;
    }

    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        return HandlerSelectionResult.from(request, this.delegates).resultOrException();
    }

    public RequestMatchResult match(HttpServletRequest request, String pattern) {
        try {
            return HandlerSelectionResult.from(request, this.delegates).match(pattern);
        }
        catch (Exception o_O) {
            return null;
        }
    }

    private static class HandlerSelectionResult {
        private final HttpServletRequest request;
        private final HandlerMapping mapping;
        private final HandlerExecutionChain result;
        private final Exception ignoredException;

        public static HandlerSelectionResult from(HttpServletRequest request, Iterable<HandlerMapping> delegates) throws Exception {
            Throwable ignoredException = null;
            for (HandlerMapping delegate : delegates) {
                try {
                    HandlerExecutionChain result = delegate.getHandler(request);
                    if (result == null) continue;
                    return HandlerSelectionResult.forResult(request, delegate, result);
                }
                catch (HttpMediaTypeNotSupportedException o_O) {
                    ignoredException = o_O;
                }
                catch (HttpMediaTypeNotAcceptableException o_O) {
                    ignoredException = o_O;
                }
                catch (HttpRequestMethodNotSupportedException o_O) {
                    ignoredException = o_O;
                }
                catch (UnsatisfiedServletRequestParameterException o_O) {
                    ignoredException = o_O;
                }
            }
            return HandlerSelectionResult.withoutResult(request, ignoredException);
        }

        private static HandlerSelectionResult forResult(HttpServletRequest request, HandlerMapping delegate, HandlerExecutionChain result) {
            return new HandlerSelectionResult(request, delegate, result, null);
        }

        private static HandlerSelectionResult withoutResult(HttpServletRequest request, Exception exception) {
            return new HandlerSelectionResult(request, null, null, exception);
        }

        public HandlerExecutionChain resultOrException() throws Exception {
            if (this.ignoredException != null) {
                throw this.ignoredException;
            }
            return this.result;
        }

        public RequestMatchResult match(String pattern) {
            return MatchableHandlerMapping.class.isInstance(this.mapping) ? ((MatchableHandlerMapping)this.mapping).match(this.request, pattern) : null;
        }

        public HandlerSelectionResult(HttpServletRequest request, HandlerMapping mapping, HandlerExecutionChain result, Exception ignoredException) {
            Assert.notNull((Object)request, (String)"HttpServletRequest must not be null!");
            this.request = request;
            this.mapping = mapping;
            this.result = result;
            this.ignoredException = ignoredException;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HandlerSelectionResult)) {
                return false;
            }
            HandlerSelectionResult other = (HandlerSelectionResult)o;
            return Objects.equals(this.request, other.request) && Objects.equals(this.mapping, other.mapping) && Objects.equals(this.result, other.result) && Objects.equals(this.ignoredException, other.ignoredException);
        }

        public int hashCode() {
            return Objects.hash(this.request, this.mapping, this.result, this.ignoredException);
        }

        public String toString() {
            return "DelegatingHandlerMapping.HandlerSelectionResult(request=" + this.request + ", mapping=" + this.mapping + ", result=" + this.result + ", ignoredException=" + this.ignoredException + ")";
        }
    }
}

