/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.util.Iterator;
import java.util.List;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.data.util.Streamable;

public class Patch
implements Streamable<PatchOperation> {
    private final List<PatchOperation> operations;

    public Patch(List<PatchOperation> operations) {
        this.operations = operations;
    }

    public int size() {
        return this.operations.size();
    }

    public <T> T apply(T in, Class<T> type) throws PatchException {
        for (PatchOperation operation : this.operations) {
            operation.perform(in, type);
        }
        return in;
    }

    public <T> List<T> apply(List<T> in, Class<T> type) throws PatchException {
        for (PatchOperation operation : this.operations) {
            operation.perform(in, type);
        }
        return in;
    }

    public Iterator<PatchOperation> iterator() {
        return this.operations.iterator();
    }
}

