/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslRepositoryInvokerAdapter;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.webmvc.config.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.util.Pair;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver
extends RootResourceInformationHandlerMethodArgumentResolver {
    private final Repositories repositories;
    private final QuerydslPredicateBuilder predicateBuilder;
    private final QuerydslBindingsFactory factory;

    public QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(Repositories repositories, RepositoryInvokerFactory invokerFactory, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver, QuerydslPredicateBuilder predicateBuilder, QuerydslBindingsFactory factory) {
        super(repositories, invokerFactory, resourceMetadataResolver);
        this.repositories = repositories;
        this.predicateBuilder = predicateBuilder;
        this.factory = factory;
    }

    @Override
    protected RepositoryInvoker postProcess(MethodParameter parameter, RepositoryInvoker invoker, Class<?> domainType, Map<String, String[]> parameters) {
        if (!parameter.hasParameterAnnotation(QuerydslPredicate.class)) {
            return invoker;
        }
        return this.repositories.getRepositoryFor(domainType).filter(it -> QuerydslPredicateExecutor.class.isInstance(it)).map(it -> (QuerydslPredicateExecutor)QuerydslPredicateExecutor.class.cast(it)).flatMap(it -> this.getRepositoryAndPredicate((QuerydslPredicateExecutor<?>)it, domainType, parameters)).map(it -> QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver.getQuerydslAdapter(invoker, (QuerydslPredicateExecutor)it.getFirst(), (Predicate)it.getSecond())).orElse(invoker);
    }

    private Optional<Pair<QuerydslPredicateExecutor<?>, Predicate>> getRepositoryAndPredicate(QuerydslPredicateExecutor<?> repository, Class<?> domainType, Map<String, String[]> parameters) {
        TypeInformation type = TypeInformation.of(domainType);
        QuerydslBindings bindings = this.factory.createBindingsFor(type);
        Predicate predicate = this.predicateBuilder.getPredicate(type, QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver.toMultiValueMap(parameters), bindings);
        return Optional.ofNullable(predicate).map(it -> Pair.of((Object)repository, (Object)it));
    }

    private static RepositoryInvoker getQuerydslAdapter(RepositoryInvoker invoker, QuerydslPredicateExecutor<?> repository, Predicate predicate) {
        return new QuerydslRepositoryInvokerAdapter(invoker, repository, predicate);
    }

    private static MultiValueMap<String, String> toMultiValueMap(Map<String, String[]> source) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        for (Map.Entry<String, String[]> entry : source.entrySet()) {
            result.put((Object)entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return result;
    }
}

