/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Slice;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.data.web.SlicedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.core.EmbeddedWrappers;
import org.springframework.util.Assert;

public class RepresentationModelAssemblers {
    private static final EmbeddedWrappers WRAPPERS = new EmbeddedWrappers(false);
    private final PagedResourcesAssembler<Object> pagedResourcesAssembler;
    private final SlicedResourcesAssembler<Object> slicedResourcesAssembler;
    private final PersistentEntityResourceAssembler persistentEntityResourceAssembler;

    public RepresentationModelAssemblers(PagedResourcesAssembler<Object> pagedResourcesAssembler, SlicedResourcesAssembler<Object> slicedResourcesAssembler, PersistentEntityResourceAssembler persistentEntityResourceAssembler) {
        Assert.notNull(pagedResourcesAssembler, (String)"PagedResourcesAssembler must not be null");
        Assert.notNull(slicedResourcesAssembler, (String)"SlicedResourcesAssembler must not be null");
        Assert.notNull((Object)persistentEntityResourceAssembler, (String)"PersistentEntityResourceAssembler must not be null");
        this.pagedResourcesAssembler = pagedResourcesAssembler;
        this.slicedResourcesAssembler = slicedResourcesAssembler;
        this.persistentEntityResourceAssembler = persistentEntityResourceAssembler;
    }

    CollectionModel<?> toCollectionModel(@Nullable Iterable<?> source, Class<?> domainType) {
        Assert.notNull(source, (String)"Source Iterable must not be null!");
        Assert.notNull(domainType, (String)"Domain type must not be null!");
        if (source instanceof Page) {
            Page page = (Page)source;
            return this.entitiesToResources((Page<Object>)page, domainType);
        }
        if (source instanceof Slice) {
            Slice slice = (Slice)source;
            return this.entitiesToResources((Slice<Object>)slice, domainType);
        }
        if (source instanceof Iterable) {
            return this.entitiesToResources(source, domainType);
        }
        return CollectionModel.empty(domainType, (Class[])new Class[0]);
    }

    PersistentEntityResource toFullResource(Object instance) {
        return this.persistentEntityResourceAssembler.toFullResource(instance);
    }

    PersistentEntityResource toModel(Object instance) {
        return this.persistentEntityResourceAssembler.toModel(instance);
    }

    Link getExpandedSelfLink(Object instance) {
        return this.persistentEntityResourceAssembler.getExpandedSelfLink(instance);
    }

    private CollectionModel<?> entitiesToResources(Page<Object> page, Class<?> domainType) {
        return page.isEmpty() ? this.pagedResourcesAssembler.toEmptyModel(page, domainType) : this.pagedResourcesAssembler.toModel(page, (RepresentationModelAssembler)this.persistentEntityResourceAssembler);
    }

    private CollectionModel<?> entitiesToResources(Slice<Object> slice, Class<?> domainType) {
        return slice.isEmpty() ? this.slicedResourcesAssembler.toEmptyModel(slice, domainType) : this.slicedResourcesAssembler.toModel(slice, (RepresentationModelAssembler)this.persistentEntityResourceAssembler);
    }

    private CollectionModel<?> entitiesToResources(Iterable<Object> entities, Class<?> domainType) {
        Link selfLink = ControllerUtils.getDefaultSelfLink();
        return !entities.iterator().hasNext() ? CollectionModel.of(List.of(WRAPPERS.emptyCollectionOf(domainType)), (Link[])new Link[]{selfLink}) : (CollectionModel)this.persistentEntityResourceAssembler.toCollectionModel(entities).add(selfLink);
    }
}

