/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.util.Map;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.convert.SolrjConverters;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.Update;
import org.springframework.data.solr.server.SolrServerFactory;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingSolrConverter
implements SolrConverter,
ApplicationContextAware,
InitializingBean {
    private final MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext;
    private final GenericConversionService conversionService;
    private ApplicationContext applicationContext;
    private SolrServerFactory solrServerFactory;

    public MappingSolrConverter(SolrServerFactory solrServerFactory, MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext) {
        Assert.notNull((Object)solrServerFactory);
        Assert.notNull(mappingContext);
        this.solrServerFactory = solrServerFactory;
        this.mappingContext = mappingContext;
        this.conversionService = new DefaultConversionService();
    }

    public MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public <R> R read(Class<R> type, Map<String, ?> source) {
        return (R)this.read(ClassTypeInformation.from(type), source);
    }

    protected <S> S read(TypeInformation<S> targetTypeInformation, Map<String, ?> source) {
        Class rawType = targetTypeInformation.getType();
        if (!this.conversionService.canConvert(SolrDocument.class, rawType)) {
            this.initializeTypedConverter(source, rawType);
        }
        return (S)this.conversionService.convert(source, rawType);
    }

    public void write(Object source, Map target) {
        if (source == null) {
            return;
        }
        SolrInputDocument convertedDocument = (SolrInputDocument)this.conversionService.convert(source, SolrInputDocument.class);
        target.putAll(convertedDocument);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }

    private void initializeConverters() {
        if (!this.conversionService.canConvert(Update.class, SolrInputDocument.class)) {
            this.conversionService.addConverter((Converter)new SolrjConverters.UpdateToSolrInputDocumentConverter());
        }
        if (!this.conversionService.canConvert(Object.class, SolrInputDocument.class)) {
            this.conversionService.addConverter((Converter)new SolrjConverters.ObjectToSolrInputDocumentConverter(this.solrServerFactory.getSolrServer().getBinder()));
        }
    }

    private <S> void initializeTypedConverter(Map<String, ?> source, Class<? extends S> rawType) {
        this.conversionService.addConverter(source.getClass(), rawType, new SolrjConverters.SolrInputDocumentToObjectConverter<S>(rawType));
    }
}

