/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.mapping;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSolrPersistentEntity<T>
extends BasicPersistentEntity<T, SolrPersistentProperty>
implements SolrPersistentEntity<T>,
ApplicationContextAware {
    private final StandardEvaluationContext context = new StandardEvaluationContext();
    private String solrCoreName;

    public SimpleSolrPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        this.solrCoreName = this.derivateSolrCoreNameFromClass(typeInformation.getType());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    private String derivateSolrCoreNameFromClass(Class<?> clazz) {
        SolrDocument solrDocument;
        String derivativeSolrCoreName = clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
        if (clazz.isAnnotationPresent(SolrDocument.class) && StringUtils.hasText((String)(solrDocument = clazz.getAnnotation(SolrDocument.class)).solrCoreName())) {
            derivativeSolrCoreName = solrDocument.solrCoreName();
        }
        return derivativeSolrCoreName;
    }

    @Override
    public String getSolrCoreName() {
        return this.solrCoreName;
    }
}

