/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetOptions {
    public static final int DEFAULT_FACET_MIN_COUNT = 1;
    public static final int DEFAULT_FACET_LIMIT = 10;
    public static final FacetSort DEFAULT_FACET_SORT = FacetSort.COUNT;
    private List<Field> facetOnFields = new ArrayList<Field>(1);
    private List<SolrDataQuery> facetQueries = new ArrayList<SolrDataQuery>(0);
    private int facetMinCount = 1;
    private int facetLimit = 10;
    private FacetSort facetSort = DEFAULT_FACET_SORT;
    private Pageable pageable;

    public FacetOptions() {
    }

    public FacetOptions(String ... fieldnames) {
        Assert.notNull((Object)fieldnames, (String)"Fields must not be null.");
        Assert.noNullElements((Object[])fieldnames, (String)"Cannot facet on null fieldname.");
        for (String fieldname : fieldnames) {
            this.addFacetOnField(fieldname);
        }
    }

    public FacetOptions(Field ... fields) {
        Assert.notNull((Object)fields, (String)"Fields must not be null.");
        Assert.noNullElements((Object[])fields, (String)"Cannot facet on null field.");
        for (Field field : fields) {
            this.addFacetOnField(field);
        }
    }

    public FacetOptions(SolrDataQuery ... facetQueries) {
        Assert.notNull((Object)facetQueries, (String)"Facet Queries must not be null.");
        Assert.noNullElements((Object[])facetQueries, (String)"Cannot facet on null query.");
        this.facetQueries.addAll(Arrays.asList(facetQueries));
    }

    public final FacetOptions addFacetOnField(Field field) {
        Assert.notNull((Object)field, (String)"Cannot facet on null field.");
        Assert.hasText((String)field.getName(), (String)"Cannot facet on field with null/empty fieldname.");
        this.facetOnFields.add(field);
        return this;
    }

    public final FacetOptions addFacetOnField(String fieldname) {
        this.addFacetOnField(new SimpleField(fieldname));
        return this;
    }

    public final FacetOptions addFacetOnFlieldnames(Collection<String> fieldnames) {
        Assert.notNull(fieldnames);
        for (String fieldname : fieldnames) {
            this.addFacetOnField(fieldname);
        }
        return this;
    }

    public final FacetOptions addFacetQuery(SolrDataQuery facetQuery) {
        Assert.notNull((Object)facetQuery, (String)"Facet Query must not be null.");
        this.facetQueries.add(facetQuery);
        return this;
    }

    public List<SolrDataQuery> getFacetQueries() {
        return Collections.unmodifiableList(this.facetQueries);
    }

    public FacetOptions setFacetMinCount(int minCount) {
        this.facetMinCount = Math.max(0, minCount);
        return this;
    }

    public FacetOptions setFacetLimit(int rowsToReturn) {
        this.facetLimit = Math.max(1, rowsToReturn);
        return this;
    }

    public FacetOptions setFacetSort(FacetSort facetSort) {
        Assert.notNull((Object)((Object)facetSort), (String)"FacetSort must not be null.");
        this.facetSort = facetSort;
        return this;
    }

    public final List<Field> getFacetOnFields() {
        return Collections.unmodifiableList(this.facetOnFields);
    }

    public int getFacetMinCount() {
        return this.facetMinCount;
    }

    public int getFacetLimit() {
        return this.facetLimit;
    }

    public FacetSort getFacetSort() {
        return this.facetSort;
    }

    public Pageable getPageable() {
        return this.pageable != null ? this.pageable : new PageRequest(0, this.facetLimit);
    }

    public FacetOptions setPageable(Pageable pageable) {
        this.pageable = pageable;
        return this;
    }

    public boolean hasFields() {
        return !this.facetOnFields.isEmpty();
    }

    public boolean hasFacetQueries() {
        return !this.facetQueries.isEmpty();
    }

    public boolean hasFacets() {
        return this.hasFields() || this.hasFacetQueries();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FacetSort {
        COUNT,
        INDEX;

    }
}

