/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.result.FacetEntry;
import org.springframework.data.solr.core.query.result.FacetFieldEntry;
import org.springframework.data.solr.core.query.result.FacetQueryEntry;
import org.springframework.data.solr.core.query.result.PageKey;
import org.springframework.data.solr.core.query.result.StringPageKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetPage<T>
extends PageImpl<T> {
    private static final long serialVersionUID = 9024455741261109788L;
    private Map<PageKey, Page<FacetFieldEntry>> facetResultPages = new LinkedHashMap<PageKey, Page<FacetFieldEntry>>(1);
    private Page<FacetQueryEntry> facetQueryResult;

    public FacetPage(List<T> content) {
        super(content);
    }

    public FacetPage(List<T> content, Pageable pageable, long total) {
        super(content, pageable, total);
    }

    public final Page<FacetFieldEntry> getFacetResultPage(Field field) {
        PageImpl page = this.facetResultPages.get(new StringPageKey(field.getName()));
        return page != null ? page : new PageImpl(Collections.emptyList());
    }

    public final void addFacetResultPage(Page<FacetFieldEntry> page, Field field) {
        this.facetResultPages.put(new StringPageKey(field.getName()), page);
    }

    public void addAllFacetFieldResultPages(Map<Field, Page<FacetFieldEntry>> pageMap) {
        for (Map.Entry<Field, Page<FacetFieldEntry>> entry : pageMap.entrySet()) {
            this.addFacetResultPage(entry.getValue(), entry.getKey());
        }
    }

    public Collection<Page<FacetFieldEntry>> getFacetResultPages() {
        return Collections.unmodifiableCollection(this.facetResultPages.values());
    }

    public final void setFacetQueryResultPage(List<FacetQueryEntry> facetQueryResult) {
        this.facetQueryResult = new PageImpl(facetQueryResult);
    }

    public Page<FacetQueryEntry> getFacetQueryResult() {
        return this.facetQueryResult != null ? this.facetQueryResult : new PageImpl(Collections.emptyList());
    }

    public Collection<Field> getFacetFields() {
        if (this.facetResultPages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>(this.facetResultPages.size());
        for (PageKey pageKey : this.facetResultPages.keySet()) {
            fields.add(new SimpleField(pageKey.getKey().toString()));
        }
        return fields;
    }

    public Collection<Page<? extends FacetEntry>> getAllFacets() {
        ArrayList<Page<? extends FacetEntry>> entries = new ArrayList<Page<? extends FacetEntry>>(this.facetResultPages.size() + 1);
        entries.addAll(this.facetResultPages.values());
        entries.add(this.facetQueryResult);
        return entries;
    }
}

