/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.solr.core.geo.BoundingBox;
import org.springframework.data.solr.core.geo.Distance;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SolrQueryCreator
extends AbstractQueryCreator<Query, Query> {
    private final MappingContext<?, SolrPersistentProperty> context;

    public SolrQueryCreator(PartTree tree, MappingContext<?, SolrPersistentProperty> context) {
        super(tree);
        this.context = context;
    }

    public SolrQueryCreator(PartTree tree, ParameterAccessor parameters, MappingContext<?, SolrPersistentProperty> context) {
        super(tree, parameters);
        this.context = context;
    }

    protected Query create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        return new SimpleQuery(this.from(part.getType(), new Criteria(path.toDotPath((Converter)SolrPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), iterator));
    }

    protected Query and(Part part, Query base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        return (Query)base.addCriteria(this.from(part.getType(), new Criteria(path.toDotPath((Converter)SolrPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), iterator));
    }

    protected Query or(Query base, Query query) {
        return new SimpleQuery(base.getCriteria().or(query.getCriteria()));
    }

    protected Query complete(Query query, Sort sort) {
        if (query == null) {
            return null;
        }
        return query.addSort(sort);
    }

    private Criteria from(Part.Type type, Criteria instance, Iterator<?> parameters) {
        Criteria criteria = instance;
        if (criteria == null) {
            criteria = new Criteria();
        }
        switch (type) {
            case TRUE: {
                return criteria.is(true);
            }
            case FALSE: {
                return criteria.is(false);
            }
            case SIMPLE_PROPERTY: {
                return criteria.is(parameters.next());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.is(parameters.next()).not();
            }
            case REGEX: {
                return criteria.expression(parameters.next().toString());
            }
            case LIKE: 
            case STARTING_WITH: {
                return criteria.startsWith(parameters.next().toString());
            }
            case NOT_LIKE: {
                return criteria.startsWith(parameters.next().toString()).not();
            }
            case ENDING_WITH: {
                return criteria.endsWith(parameters.next().toString());
            }
            case CONTAINING: {
                return criteria.contains(parameters.next().toString());
            }
            case AFTER: 
            case GREATER_THAN: {
                return criteria.greaterThan(parameters.next());
            }
            case GREATER_THAN_EQUAL: {
                return criteria.greaterThanEqual(parameters.next());
            }
            case BEFORE: 
            case LESS_THAN: {
                return criteria.lessThan(parameters.next());
            }
            case LESS_THAN_EQUAL: {
                return criteria.lessThanEqual(parameters.next());
            }
            case BETWEEN: {
                return criteria.between(parameters.next(), parameters.next());
            }
            case IN: {
                return criteria.in(this.asArray(parameters.next()));
            }
            case NOT_IN: {
                return criteria.in(this.asArray(parameters.next())).not();
            }
            case NEAR: {
                return this.createNearCriteria(parameters, criteria);
            }
            case WITHIN: {
                return criteria.within((GeoLocation)parameters.next(), (Distance)parameters.next());
            }
        }
        throw new InvalidDataAccessApiUsageException("Illegal criteria found '" + type + "'.");
    }

    private Criteria createNearCriteria(Iterator<?> parameters, Criteria criteria) {
        Object value = parameters.next();
        if (value instanceof BoundingBox) {
            return criteria.near((BoundingBox)value);
        }
        return criteria.near((GeoLocation)value, (Distance)parameters.next());
    }

    private Object[] asArray(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).toArray();
        }
        if (o.getClass().isArray()) {
            return (Object[])o;
        }
        return new Object[]{o};
    }
}

