/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.data.solr.server.SolrServerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.xml.sax.SAXException;

public class EmbeddedSolrServerFactory
implements SolrServerFactory {
    private static final String SOLR_HOME_SYSTEM_PROPERTY = "solr.solr.home";
    private String solrHome;
    private EmbeddedSolrServer solrServer;

    protected EmbeddedSolrServerFactory() {
    }

    public EmbeddedSolrServerFactory(String solrHome) throws ParserConfigurationException, IOException, SAXException {
        Assert.hasText((String)solrHome);
        this.solrHome = solrHome;
    }

    public EmbeddedSolrServer getSolrServer() {
        if (this.solrServer == null) {
            this.initSolrServer();
        }
        return this.solrServer;
    }

    protected void initSolrServer() {
        try {
            this.solrServer = this.createPathConfiguredSolrServer(this.solrHome);
        }
        catch (ParserConfigurationException e) {
            throw new BeanInstantiationException(EmbeddedSolrServer.class, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BeanInstantiationException(EmbeddedSolrServer.class, e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new BeanInstantiationException(EmbeddedSolrServer.class, e.getMessage(), (Throwable)e);
        }
    }

    public final EmbeddedSolrServer createPathConfiguredSolrServer(String path) throws ParserConfigurationException, IOException, SAXException {
        String solrHomeDirectory = System.getProperty(SOLR_HOME_SYSTEM_PROPERTY);
        if (StringUtils.isBlank((String)solrHomeDirectory)) {
            solrHomeDirectory = ResourceUtils.getURL((String)path).getPath();
        }
        return new EmbeddedSolrServer(new CoreContainer(solrHomeDirectory, new File(solrHomeDirectory + "/solr.xml")), null);
    }

    public void shutdownSolrServer() {
        if (this.solrServer != null && this.solrServer.getCoreContainer() != null) {
            this.solrServer.getCoreContainer().shutdown();
        }
    }

    public String getCore() {
        return null;
    }

    public void setSolrHome(String solrHome) {
        Assert.hasText((String)solrHome);
        this.solrHome = solrHome;
    }
}

