/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.geo.Point;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.util.Assert;

public class DistanceFunction
extends AbstractFunction {
    private static final String OPERATION = "dist";

    private DistanceFunction(Power power) {
        super(Arrays.asList(power.getValue()));
    }

    public static Builder sparsenessDistance() {
        return new Builder(Power.SPARSENESS_CALCULATION);
    }

    public static Builder manhattanDistance() {
        return new Builder(Power.MANHATTAN_DISTANCE);
    }

    public static Builder euclideanDistance() {
        return new Builder(Power.EUCLIDEAN_DISTANCE);
    }

    public static Builder infiniteNormDistance() {
        return new Builder(Power.INFINITE_NORM);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private DistanceFunction function;

        public Builder(Power power) {
            Assert.notNull((Object)((Object)power), (String)"Calculation type must not be 'null'.");
            this.function = new DistanceFunction(power);
        }

        public DistanceFunction between(Point point1, Point point2) {
            Assert.notNull((Object)point1, (String)"Parameter 'point1' must not be null");
            Assert.notNull((Object)point2, (String)"Parameter 'point2' must not be null");
            this.function.addArgument(point1);
            this.function.addArgument(point2);
            return this.function;
        }
    }

    public static enum Power {
        SPARSENESS_CALCULATION("0"),
        MANHATTAN_DISTANCE("1"),
        EUCLIDEAN_DISTANCE("2"),
        INFINITE_NORM("Infinite");

        private String value;

        private Power(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

