/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SolrServerUtils {
    private static final Logger logger = LoggerFactory.getLogger(SolrServerUtils.class);
    private static final String SLASH = "/";

    private SolrServerUtils() {
    }

    public static String resolveSolrCoreName(Class<?> type) {
        SolrDocument annotation = (SolrDocument)AnnotationUtils.findAnnotation(type, SolrDocument.class);
        if (annotation != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)annotation.solrCoreName())) {
            return annotation.solrCoreName();
        }
        return "";
    }

    public static <T extends SolrServer> T clone(T solrServer) {
        return SolrServerUtils.clone(solrServer, null);
    }

    public static <T extends SolrServer> T clone(T solrServer, String core) {
        Assert.notNull(solrServer);
        String shortName = SolrServerUtils.getSolrServerTypeName(solrServer);
        if (shortName.equals("SolrServer")) {
            return solrServer;
        }
        SolrServer clone = null;
        if (shortName.equals("HttpSolrServer") || shortName.equals("CommonsHttpSolrServer")) {
            clone = SolrServerUtils.cloneHttpSolrServer(solrServer, core);
        } else if (shortName.equals("LBHttpSolrServer")) {
            clone = SolrServerUtils.cloneLBHttpSolrServer(solrServer, core);
        } else if (shortName.equals("CloudSolrServer")) {
            clone = SolrServerUtils.cloneCloudSolrServer(solrServer, core);
        } else if (shortName.equals("EmbeddedSolrServer")) {
            clone = SolrServerUtils.cloneEmbeddedSolrServer(solrServer);
        }
        if (clone == null) {
            throw new BeanInstantiationException(solrServer.getClass(), "Cannot create instace of " + shortName + ".");
        }
        SolrServerUtils.copyProperties(solrServer, clone);
        return (T)clone;
    }

    public static String appendCoreToBaseUrl(String baseUrl, String core) {
        Assert.notNull((Object)baseUrl);
        if (!StringUtils.hasText((String)core)) {
            return baseUrl;
        }
        String url = baseUrl;
        if (!org.apache.commons.lang3.StringUtils.endsWith((CharSequence)baseUrl, (CharSequence)SLASH)) {
            url = url + SLASH;
        }
        url = url + core;
        return url;
    }

    private static String getSolrServerTypeName(SolrServer solrServer) {
        Class<?> solrServerType = ClassUtils.isCglibProxy((Object)solrServer) ? ClassUtils.getUserClass((Object)solrServer) : solrServer.getClass();
        String shortName = ClassUtils.getShortName(solrServerType);
        return shortName;
    }

    private static SolrServer cloneEmbeddedSolrServer(SolrServer solrServer) {
        String solrHome = ((EmbeddedSolrServer)solrServer).getCoreContainer().getSolrHome();
        try {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(solrServer.getClass(), (Class[])new Class[]{CoreContainer.class, String.class});
            return (SolrServer)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{new CoreContainer(solrHome), null});
        }
        catch (Exception e) {
            throw new BeanInstantiationException(solrServer.getClass(), "Cannot create instace of " + solrServer.getClass() + ".", (Throwable)e);
        }
    }

    private static SolrServer cloneHttpSolrServer(SolrServer solrServer, String core) {
        if (solrServer == null) {
            return null;
        }
        Method baseUrlGetterMethod = ClassUtils.getMethodIfAvailable(solrServer.getClass(), (String)"getBaseURL", (Class[])new Class[0]);
        if (baseUrlGetterMethod == null) {
            return null;
        }
        String baseUrl = (String)ReflectionUtils.invokeMethod((Method)baseUrlGetterMethod, (Object)solrServer);
        String url = SolrServerUtils.appendCoreToBaseUrl(baseUrl, core);
        Constructor constructor = ClassUtils.getConstructorIfAvailable(solrServer.getClass(), (Class[])new Class[]{String.class});
        return (SolrServer)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{url});
    }

    private static LBHttpSolrServer cloneLBHttpSolrServer(SolrServer solrServer, String core) {
        if (solrServer == null) {
            return null;
        }
        LBHttpSolrServer clone = null;
        try {
            if (VersionUtil.isSolr3XAvailable()) {
                clone = SolrServerUtils.cloneSolr3LBHttpServer(solrServer, core);
            } else if (VersionUtil.isSolr4XAvailable()) {
                clone = SolrServerUtils.cloneSolr4LBHttpServer(solrServer, core);
            }
        }
        catch (MalformedURLException e) {
            throw new BeanInstantiationException(solrServer.getClass(), "Cannot create instace of " + solrServer.getClass() + ". ", (Throwable)e);
        }
        Object o = SolrServerUtils.readField(solrServer, "interval");
        if (o != null) {
            clone.setAliveCheckInterval(Integer.valueOf(o.toString()).intValue());
        }
        return clone;
    }

    private static SolrServer cloneCloudSolrServer(SolrServer solrServer, String core) {
        if (VersionUtil.isSolr3XAvailable() || solrServer == null) {
            return null;
        }
        CloudSolrServer cloudServer = (CloudSolrServer)solrServer;
        String zkHost = (String)SolrServerUtils.readField(solrServer, "zkHost");
        Constructor constructor = ClassUtils.getConstructorIfAvailable(solrServer.getClass(), (Class[])new Class[]{String.class, LBHttpSolrServer.class});
        return (SolrServer)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{zkHost, SolrServerUtils.cloneLBHttpSolrServer((SolrServer)cloudServer.getLbServer(), core)});
    }

    private static LBHttpSolrServer cloneSolr3LBHttpServer(SolrServer solrServer, String core) throws MalformedURLException {
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)SolrServerUtils.readField(solrServer, "aliveServers");
        String[] servers = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            servers[i] = SolrServerUtils.appendCoreToBaseUrl(list.get(i).toString(), core);
        }
        return new LBHttpSolrServer(servers);
    }

    private static LBHttpSolrServer cloneSolr4LBHttpServer(SolrServer solrServer, String core) throws MalformedURLException {
        Map map = (Map)SolrServerUtils.readField(solrServer, "aliveServers");
        String[] servers = new String[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            servers[i] = SolrServerUtils.appendCoreToBaseUrl(key, core);
            ++i;
        }
        return new LBHttpSolrServer(servers);
    }

    private static <T> T readField(SolrServer solrServer, String fieldName) {
        Field field = ReflectionUtils.findField(solrServer.getClass(), (String)fieldName);
        if (field == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        return (T)ReflectionUtils.getField((Field)field, (Object)solrServer);
    }

    private static void copyProperties(SolrServer source, SolrServer target) {
        BeanWrapperImpl wrapperImpl = new BeanWrapperImpl((Object)source);
        for (PropertyDescriptor pd : wrapperImpl.getPropertyDescriptors()) {
            Method writer = pd.getWriteMethod();
            if (writer == null) continue;
            try {
                Field property = ReflectionUtils.findField(source.getClass(), (String)pd.getName());
                if (property == null) continue;
                ReflectionUtils.makeAccessible((Field)property);
                Object o = ReflectionUtils.getField((Field)property, (Object)source);
                if (o == null) continue;
                writer.invoke((Object)target, o);
            }
            catch (Exception e) {
                logger.warn("Could not copy property value for: " + pd.getName(), (Throwable)e);
            }
        }
    }
}

