/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.test.junit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Job;
import org.springframework.data.hadoop.mapreduce.JobUtils;
import org.springframework.data.hadoop.test.junit.AbstractHadoopClusterTests;
import org.springframework.util.Assert;

public class AbstractMapReduceTests
extends AbstractHadoopClusterTests {
    protected Path[] getOutputFilePaths(String outputDirectory) throws FileNotFoundException, IOException {
        return this.getOutputFilePaths(new Path(outputDirectory));
    }

    protected Path[] getOutputFilePaths(Path outputDirectory) throws FileNotFoundException, IOException {
        return FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(outputDirectory, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
    }

    protected JobUtils.JobStatus waitFinishedStatus(Job job, long timeout, TimeUnit unit) throws Exception {
        return this.waitStatus(job, timeout, unit, JobUtils.JobStatus.SUCCEEDED, JobUtils.JobStatus.FAILED, JobUtils.JobStatus.KILLED);
    }

    protected JobUtils.JobStatus waitStatus(Job job, long timeout, TimeUnit unit, JobUtils.JobStatus ... jobStatuses) throws Exception {
        Assert.notNull((Object)job, (String)"Hadoop job must be set");
        JobUtils.JobStatus status = null;
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        block0: while ((status = this.findStatus(job)) != null) {
            for (JobUtils.JobStatus statusCheck : jobStatuses) {
                if (status.equals((Object)statusCheck)) break block0;
            }
            Thread.sleep(1000L);
            if (System.currentTimeMillis() < end) continue;
        }
        return status;
    }

    protected JobUtils.JobStatus findStatus(Job job) {
        return JobUtils.getStatus((Job)job);
    }
}

