/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.sql.DataSource;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.config.IntegrationConverter;
import org.springframework.integration.ip.tcp.TcpInboundGateway;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpNetServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpSocketSupport;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.yarn.am.AppmasterService;
import org.springframework.yarn.batch.repository.BatchAppmasterService;
import org.springframework.yarn.batch.repository.JobRepositoryService;
import org.springframework.yarn.event.DefaultYarnEventPublisher;
import org.springframework.yarn.event.YarnEventPublisher;
import org.springframework.yarn.integration.convert.MindHolderToObjectConverter;
import org.springframework.yarn.integration.convert.MindObjectToHolderConverter;
import org.springframework.yarn.integration.ip.mind.MindRpcSerializer;
import org.springframework.yarn.integration.support.DefaultPortExposingTcpSocketSupport;
import org.springframework.yarn.integration.support.Jackson2ObjectMapperFactoryBean;
import org.springframework.yarn.integration.support.PortExposingTcpSocketSupport;

@Configuration
public class SimpleYarnBatchConfiguration {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private JobRepository jobRepository;

    @Bean
    public YarnEventPublisher yarnEventPublisher() {
        return new DefaultYarnEventPublisher();
    }

    @Bean
    public JobRepositoryService jobRepositoryService() throws Exception {
        JobRepositoryService service = new JobRepositoryService();
        service.setJobExplorer(this.jobExplorer());
        service.setJobRepository(this.jobRepository);
        return service;
    }

    @Bean
    public JobExplorer jobExplorer() throws Exception {
        JobExplorerFactoryBean factory = new JobExplorerFactoryBean();
        factory.setDataSource(this.dataSource);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    public ObjectMapper objectMapper() {
        Jackson2ObjectMapperFactoryBean factory = new Jackson2ObjectMapperFactoryBean();
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    @IntegrationConverter
    public MindObjectToHolderConverter mindObjectToHolderConverter() {
        return new MindObjectToHolderConverter(this.objectMapper());
    }

    @Bean
    @IntegrationConverter
    public MindHolderToObjectConverter mindHolderToObjectConverter() {
        String[] packages = new String[]{"org.springframework.yarn.batch.repository.bindings", "org.springframework.yarn.batch.repository.bindings.exp", "org.springframework.yarn.batch.repository.bindings.repo"};
        return new MindHolderToObjectConverter(this.objectMapper(), packages);
    }

    @Bean
    public DirectChannel directChannel() {
        return new DirectChannel();
    }

    @Bean
    public MindRpcSerializer mindRpcSerializer() {
        return new MindRpcSerializer();
    }

    @Bean
    public DefaultPortExposingTcpSocketSupport defaultPortExposingTcpSocketSupport() {
        return new DefaultPortExposingTcpSocketSupport();
    }

    @Bean
    public TcpNetServerConnectionFactory tcpNetServerConnectionFactory() {
        TcpNetServerConnectionFactory factory = new TcpNetServerConnectionFactory(0);
        factory.setTcpSocketSupport((TcpSocketSupport)this.defaultPortExposingTcpSocketSupport());
        factory.setSerializer((Serializer)this.mindRpcSerializer());
        factory.setDeserializer((Deserializer)this.mindRpcSerializer());
        return factory;
    }

    @Bean
    public TcpInboundGateway tcpInboundGateway() {
        TcpInboundGateway gateway = new TcpInboundGateway();
        gateway.setConnectionFactory((AbstractConnectionFactory)this.tcpNetServerConnectionFactory());
        gateway.setRequestChannel((MessageChannel)this.directChannel());
        return gateway;
    }

    @Bean(name={"yarnAmservice"})
    public AppmasterService appmasterService() throws Exception {
        BatchAppmasterService service = new BatchAppmasterService();
        service.setJobRepositoryRemoteService(this.jobRepositoryService());
        service.setMessageChannel((SubscribableChannel)this.directChannel());
        service.setSocketSupport((PortExposingTcpSocketSupport)this.defaultPortExposingTcpSocketSupport());
        return service;
    }
}

