/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.actuate.endpoint;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.yarn.event.AbstractYarnEvent;
import org.springframework.yarn.event.ContainerRegisterEvent;
import org.springframework.yarn.event.YarnEventPublisher;

public class YarnContainerRegisterEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    public static final String ENDPOINT_ID = "yarn_containerregister";
    private static final Log log = LogFactory.getLog(YarnContainerRegisterEndpoint.class);
    private YarnEventPublisher yarnEventPublisher;

    public YarnContainerRegisterEndpoint() {
        super(ENDPOINT_ID);
    }

    public Map<String, Object> invoke() {
        return Collections.singletonMap("message", "Use POST to report yourself");
    }

    public void register(String containerId, String trackUrl) {
        if (this.yarnEventPublisher != null) {
            this.yarnEventPublisher.publishEvent((AbstractYarnEvent)new ContainerRegisterEvent((Object)this, containerId, trackUrl));
        }
    }

    @Autowired(required=false)
    public void setYarnEventPublisher(YarnEventPublisher yarnEventPublisher) {
        log.debug((Object)("Setting yarnEventPublisher=[" + yarnEventPublisher + "]"));
        this.yarnEventPublisher = yarnEventPublisher;
    }
}

