/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.util.StringUtils;
import org.springframework.yarn.container.LongRunningYarnContainer;
import org.springframework.yarn.container.YarnContainer;
import org.springframework.yarn.launch.ExitCodeMapper;
import org.springframework.yarn.launch.JvmSystemExiter;
import org.springframework.yarn.launch.SimpleJvmExitCodeMapper;
import org.springframework.yarn.launch.SystemExiter;
import org.springframework.yarn.listener.ContainerStateListener;

public class ContainerLauncherRunner
implements CommandLineRunner {
    private static final Log log = LogFactory.getLog(ContainerLauncherRunner.class);
    private static SystemExiter systemExiter = new JvmSystemExiter();
    private ExitCodeMapper exitCodeMapper = new SimpleJvmExitCodeMapper();
    private CountDownLatch latch;
    private boolean waitLatch = true;
    @Autowired(required=false)
    private YarnContainer yarnContainer;
    private final StateWrapper stateWrapper = new StateWrapper();

    public void run(String ... args) throws Exception {
        if (this.yarnContainer != null) {
            this.launchContainer(this.yarnContainer, args);
        }
    }

    public void setWaitLatch(boolean waitLatch) {
        this.waitLatch = waitLatch;
    }

    protected void launchContainer(YarnContainer container, String[] parameters) {
        Properties properties = StringUtils.splitArrayElementsIntoProperties((String[])parameters, (String)"=");
        container.setParameters(properties != null ? properties : new Properties());
        container.setEnvironment(System.getenv());
        log.info((Object)("Running YarnContainer with parameters [" + StringUtils.arrayToCommaDelimitedString((Object[])parameters) + "]"));
        if (container instanceof LongRunningYarnContainer && ((LongRunningYarnContainer)container).isWaitCompleteState()) {
            log.info((Object)"Container requested that we wait state, setting up latch");
            this.latch = new CountDownLatch(1);
            ((LongRunningYarnContainer)container).addContainerStateListener(new ContainerStateListener(){

                public void state(ContainerStateListener.ContainerState state, Object exit) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Got state ContainerState=" + state + " and exit=" + exit));
                    }
                    ((ContainerLauncherRunner)ContainerLauncherRunner.this).stateWrapper.state = state;
                    ((ContainerLauncherRunner)ContainerLauncherRunner.this).stateWrapper.exit = exit;
                    ContainerLauncherRunner.this.latch.countDown();
                }
            });
        }
        container.run();
        if (this.waitLatch) {
            if (this.latch != null) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    log.info((Object)"YarnContainer latch wait interrupted");
                }
            }
            log.info((Object)"YarnContainer complete");
            int exitCode = 0;
            if (this.stateWrapper.state != null && this.stateWrapper.exit != null) {
                if (this.stateWrapper.exit instanceof String) {
                    exitCode = this.exitCodeMapper.intValue((String)this.stateWrapper.exit);
                } else if (this.stateWrapper.exit instanceof Boolean) {
                    exitCode = this.exitCodeMapper.intValue((Boolean)this.stateWrapper.exit);
                } else if (this.stateWrapper.exit instanceof Integer) {
                    exitCode = (Integer)this.stateWrapper.exit;
                }
            }
            log.info((Object)("Exiting with exitCode=" + exitCode));
            systemExiter.exit(exitCode);
        }
    }

    private static class StateWrapper {
        ContainerStateListener.ContainerState state;
        Object exit;

        private StateWrapper() {
        }
    }
}

