/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.EndpointWebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.yarn.am.YarnAppmaster;
import org.springframework.yarn.am.cluster.ContainerClusterStateMachineConfiguration;
import org.springframework.yarn.boot.YarnAppmasterAutoConfiguration;
import org.springframework.yarn.boot.actuate.endpoint.YarnContainerClusterEndpoint;
import org.springframework.yarn.boot.actuate.endpoint.mvc.YarnContainerClusterMvcEndpoint;
import org.springframework.yarn.boot.condition.ConditionalOnYarnAppmaster;
import org.springframework.yarn.boot.properties.SpringYarnAppmasterProperties;
import org.springframework.yarn.config.annotation.EnableYarn;

@Configuration
@ConditionalOnYarnAppmaster
@ConditionalOnClass(value={EnableYarn.class})
@ConditionalOnMissingBean(value={YarnAppmaster.class})
@ConditionalOnExpression(value="${spring.yarn.appmaster.containercluster.enabled:false}")
@AutoConfigureBefore(value={EndpointWebMvcAutoConfiguration.class, YarnAppmasterAutoConfiguration.class})
@Import(value={ContainerClusterStateMachineConfiguration.class})
public class ContainerClusterAppmasterAutoConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={SpringYarnAppmasterProperties.class})
    @ConditionalOnExpression(value="${spring.yarn.endpoints.containercluster.enabled:false}")
    public static class ContainerClusterEndPointConfig {
        @Autowired
        private SpringYarnAppmasterProperties syap;

        @Bean
        @ConditionalOnMissingBean
        public YarnContainerClusterEndpoint yarnContainerClusterEndpoint() {
            return new YarnContainerClusterEndpoint();
        }

        @Bean
        @ConditionalOnBean(value={YarnContainerClusterEndpoint.class})
        public YarnContainerClusterMvcEndpoint yarnContainerClusterMvcEndpoint(YarnContainerClusterEndpoint delegate) {
            return new YarnContainerClusterMvcEndpoint(delegate);
        }
    }
}

