/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.app;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointMBeanExportAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.SpringApplicationCallback;
import org.springframework.yarn.boot.SpringApplicationTemplate;
import org.springframework.yarn.boot.app.AbstractClientApplication;
import org.springframework.yarn.boot.support.SpringYarnBootUtils;
import org.springframework.yarn.client.YarnClient;

@Configuration
@EnableAutoConfiguration(exclude={EmbeddedServletContainerAutoConfiguration.class, WebMvcAutoConfiguration.class, JmxAutoConfiguration.class, BatchAutoConfiguration.class, JmxAutoConfiguration.class, EndpointMBeanExportAutoConfiguration.class, EndpointAutoConfiguration.class})
public class YarnKillApplication
extends AbstractClientApplication<String, YarnKillApplication> {
    @Override
    public String run() {
        return this.run(new String[0]);
    }

    @Override
    public String run(String ... args) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[0]);
        builder.web(false);
        builder.sources(new Class[]{YarnKillApplication.class, OperationProperties.class});
        SpringYarnBootUtils.addSources(builder, this.sources.toArray(new Object[0]));
        SpringYarnBootUtils.addProfiles(builder, this.profiles.toArray(new String[0]));
        if (StringUtils.hasText((String)this.applicationBaseDir)) {
            this.appProperties.setProperty("spring.yarn.applicationDir", this.applicationBaseDir + this.applicationVersion + "/");
        }
        SpringYarnBootUtils.addApplicationListener(builder, this.appProperties);
        SpringApplicationTemplate template = new SpringApplicationTemplate(builder);
        return template.execute(new SpringApplicationCallback<String>(){

            @Override
            public String runWithSpringApplication(ApplicationContext context) throws Exception {
                OperationProperties operationProperties;
                ApplicationId applicationId;
                YarnClient client = (YarnClient)context.getBean(YarnClient.class);
                ApplicationReport report = client.getApplicationReport(applicationId = ConverterUtils.toApplicationId((String)(operationProperties = (OperationProperties)context.getBean(OperationProperties.class)).getApplicationId()));
                if (report.getYarnApplicationState() == YarnApplicationState.FINISHED || report.getYarnApplicationState() == YarnApplicationState.KILLED || report.getYarnApplicationState() == YarnApplicationState.FAILED) {
                    return "Application " + applicationId + " is not running";
                }
                client.killApplication(applicationId);
                return "Kill request for " + applicationId + " sent";
            }
        }, args);
    }

    @Override
    protected YarnKillApplication getThis() {
        return this;
    }

    @ConfigurationProperties(value="spring.yarn.internal.YarnKillApplication")
    public static class OperationProperties {
        String applicationId;

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getApplicationId() {
            return this.applicationId;
        }
    }
}

