/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.app;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointMBeanExportAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.SpringApplicationCallback;
import org.springframework.yarn.boot.SpringApplicationTemplate;
import org.springframework.yarn.boot.app.AbstractClientApplication;
import org.springframework.yarn.boot.properties.SpringYarnProperties;
import org.springframework.yarn.boot.support.SpringYarnBootUtils;
import org.springframework.yarn.client.ApplicationDescriptor;
import org.springframework.yarn.client.ApplicationYarnClient;
import org.springframework.yarn.client.YarnClient;

@Configuration
@EnableAutoConfiguration(exclude={EmbeddedServletContainerAutoConfiguration.class, WebMvcAutoConfiguration.class, JmxAutoConfiguration.class, BatchAutoConfiguration.class, JmxAutoConfiguration.class, EndpointMBeanExportAutoConfiguration.class, EndpointAutoConfiguration.class})
public class YarnSubmitApplication
extends AbstractClientApplication<ApplicationId, YarnSubmitApplication> {
    private String applicationName;

    @Override
    public ApplicationId run() {
        return this.run(new String[0]);
    }

    @Override
    public ApplicationId run(String ... args) {
        Assert.state((boolean)StringUtils.hasText((String)this.applicationVersion), (String)"Instance id must be set");
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[0]);
        builder.web(false);
        builder.sources(new Class[]{YarnSubmitApplication.class});
        SpringYarnBootUtils.addSources(builder, this.sources.toArray(new Object[0]));
        SpringYarnBootUtils.addProfiles(builder, this.profiles.toArray(new String[0]));
        if (StringUtils.hasText((String)this.applicationBaseDir)) {
            this.appProperties.setProperty("spring.yarn.applicationDir", this.applicationBaseDir + this.applicationVersion + "/");
        }
        this.appProperties.setProperty("spring.yarn.applicationVersion", this.applicationVersion);
        SpringYarnBootUtils.addApplicationListener(builder, this.appProperties);
        SpringApplicationTemplate template = new SpringApplicationTemplate(builder);
        return template.execute(new SpringApplicationCallback<ApplicationId>(){

            @Override
            public ApplicationId runWithSpringApplication(ApplicationContext context) throws Exception {
                YarnClient client = (YarnClient)context.getBean(YarnClient.class);
                SpringYarnProperties syp = (SpringYarnProperties)context.getBean(SpringYarnProperties.class);
                String applicationdir = SpringYarnBootUtils.resolveApplicationdir(syp);
                if (client instanceof ApplicationYarnClient) {
                    return ((ApplicationYarnClient)client).submitApplication(new ApplicationDescriptor(applicationdir, YarnSubmitApplication.this.applicationName));
                }
                return client.submitApplication(false);
            }
        }, args);
    }

    @Override
    protected YarnSubmitApplication getThis() {
        return this;
    }

    public YarnSubmitApplication applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this.getThis();
    }
}

