/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.condition;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.yarn.boot.condition.ConditionalOnMissingYarn;
import org.springframework.yarn.boot.condition.ConditionalOnYarn;

class OnYarnClusterCondition
extends SpringBootCondition {
    private static final String TOKEN_ENV = "HADOOP_TOKEN_FILE_LOCATION";

    OnYarnClusterCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String tokenEnv = System.getenv(TOKEN_ENV);
        if (metadata.isAnnotated(ConditionalOnYarn.class.getName())) {
            if (tokenEnv != null) {
                return ConditionOutcome.match((String)"@ConditionalOnYarn found system environment variable HADOOP_TOKEN_FILE_LOCATION");
            }
            return ConditionOutcome.noMatch((String)"@ConditionalOnYarn did not found system environment variable HADOOP_TOKEN_FILE_LOCATION");
        }
        if (metadata.isAnnotated(ConditionalOnMissingYarn.class.getName())) {
            if (tokenEnv == null) {
                return ConditionOutcome.match((String)"@ConditionalOnMissingYarn did not found system environment variable HADOOP_TOKEN_FILE_LOCATION");
            }
            return ConditionOutcome.noMatch((String)"@ConditionalOnMissingYarn found system environment variable HADOOP_TOKEN_FILE_LOCATION");
        }
        return ConditionOutcome.match((String)"System environment variable HADOOP_TOKEN_FILE_LOCATION found");
    }
}

