/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.convert;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;

public class ConversionServiceCreator
implements BeanFactoryPostProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (!beanFactory.containsBean("yarnIntegrationConversionService")) {
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionBuilder conversionServiceBuilder = BeanDefinitionBuilder.rootBeanDefinition(CustomConversionServiceFactoryBean.class);
                BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder((BeanDefinition)conversionServiceBuilder.getBeanDefinition(), "yarnIntegrationConversionService");
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)beanDefinitionHolder, (BeanDefinitionRegistry)((BeanDefinitionRegistry)beanFactory));
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"BeanFactory is not a BeanDefinitionRegistry implementation. Cannot register a default ConversionService.");
            }
        }
    }

    static class CustomConversionServiceFactoryBean
    extends ConversionServiceFactoryBean {
        CustomConversionServiceFactoryBean() {
        }

        public ConversionService getObject() {
            ConversionService service = super.getObject();
            if (service instanceof GenericConversionService) {
                ((GenericConversionService)service).removeConvertible(Object.class, Object.class);
            }
            return service;
        }
    }
}

