/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.test.junit;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.Assert;
import org.springframework.yarn.client.YarnClient;
import org.springframework.yarn.test.context.YarnCluster;
import org.springframework.yarn.test.junit.ApplicationInfo;

@RunWith(value=SpringJUnit4ClassRunner.class)
public abstract class AbstractYarnClusterTests
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;
    protected Configuration configuration;
    protected YarnCluster yarnCluster;
    protected YarnClient yarnClient;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Autowired
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public YarnCluster getYarnCluster() {
        return this.yarnCluster;
    }

    @Autowired
    public void setYarnCluster(YarnCluster yarnCluster) {
        this.yarnCluster = yarnCluster;
    }

    public YarnClient getYarnClient() {
        return this.yarnClient;
    }

    @Autowired
    public void setYarnClient(YarnClient yarnClient) {
        this.yarnClient = yarnClient;
    }

    protected ApplicationInfo submitApplicationAndWait() throws Exception {
        return this.submitApplicationAndWait(60L, TimeUnit.SECONDS);
    }

    protected ApplicationInfo submitApplicationAndWait(long timeout, TimeUnit unit) throws Exception {
        return this.submitApplicationAndWaitState(timeout, unit, YarnApplicationState.FINISHED, YarnApplicationState.FAILED);
    }

    protected ApplicationInfo submitApplicationAndWaitState(long timeout, TimeUnit unit, YarnApplicationState ... applicationStates) throws Exception {
        Assert.notEmpty((Object[])applicationStates, (String)"Need to have atleast one state");
        Assert.notNull((Object)this.getYarnClient(), (String)"Yarn client must be set");
        YarnApplicationState state = null;
        ApplicationReport report = null;
        ApplicationId applicationId = this.submitApplication();
        Assert.notNull((Object)applicationId, (String)"Failed to get application id from submit");
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        block0: while ((report = this.findApplicationReport(this.getYarnClient(), applicationId)) != null) {
            state = report.getYarnApplicationState();
            for (YarnApplicationState stateCheck : applicationStates) {
                if (state.equals((Object)stateCheck)) break block0;
            }
            Thread.sleep(1000L);
            if (System.currentTimeMillis() < end) continue;
        }
        return new ApplicationInfo(applicationId, report);
    }

    protected ApplicationId submitApplication() {
        Assert.notNull((Object)this.getYarnClient(), (String)"Yarn client must be set");
        ApplicationId applicationId = this.getYarnClient().submitApplication();
        Assert.notNull((Object)applicationId, (String)"Failed to get application id from submit");
        return applicationId;
    }

    protected YarnApplicationState waitState(ApplicationId applicationId, long timeout, TimeUnit unit, YarnApplicationState ... applicationStates) throws Exception {
        Assert.notNull((Object)this.getYarnClient(), (String)"Yarn client must be set");
        Assert.notNull((Object)applicationId, (String)"ApplicationId must not be null");
        YarnApplicationState state = null;
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        block0: while ((state = this.findState(this.getYarnClient(), applicationId)) != null) {
            for (YarnApplicationState stateCheck : applicationStates) {
                if (state.equals((Object)stateCheck)) break block0;
            }
            Thread.sleep(1000L);
            if (System.currentTimeMillis() < end) continue;
        }
        return state;
    }

    protected void killApplication(ApplicationId applicationId) {
        Assert.notNull((Object)this.getYarnClient(), (String)"Yarn client must be set");
        Assert.notNull((Object)applicationId, (String)"ApplicationId must not be null");
        this.getYarnClient().killApplication(applicationId);
    }

    protected YarnApplicationState getState(ApplicationId applicationId) {
        Assert.notNull((Object)this.getYarnClient(), (String)"Yarn client must be set");
        Assert.notNull((Object)applicationId, (String)"ApplicationId must not be null");
        return this.findState(this.getYarnClient(), applicationId);
    }

    private YarnApplicationState findState(YarnClient client, ApplicationId applicationId) {
        YarnApplicationState state = null;
        for (ApplicationReport report : client.listApplications()) {
            if (!report.getApplicationId().equals((Object)applicationId)) continue;
            state = report.getYarnApplicationState();
            break;
        }
        return state;
    }

    private ApplicationReport findApplicationReport(YarnClient client, ApplicationId applicationId) {
        for (ApplicationReport report : client.listApplications()) {
            if (!report.getApplicationId().equals((Object)applicationId)) continue;
            return report;
        }
        return null;
    }
}

