/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.test.support;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.yarn.test.context.YarnCluster;
import org.springframework.yarn.test.support.ClusterInfo;
import org.springframework.yarn.test.support.YarnClusterFactoryBean;

public class YarnClusterManager {
    private static final Log log = LogFactory.getLog(YarnClusterManager.class);
    private static volatile YarnClusterManager instance = null;
    private final Object startupShutdownMonitor = new Object();
    private Thread shutdownHook;
    private Hashtable<ClusterInfo, YarnCluster> clusters = new Hashtable();

    private YarnClusterManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YarnClusterManager getInstance() {
        if (instance != null) return instance;
        Class<YarnClusterManager> clazz = YarnClusterManager.class;
        synchronized (YarnClusterManager.class) {
            if (instance != null) return instance;
            instance = new YarnClusterManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static YarnClusterManager getInstance(boolean registerShutdownHook) {
        YarnClusterManager instance2 = YarnClusterManager.getInstance();
        if (registerShutdownHook) {
            instance2.registerShutdownHook();
        }
        return instance2;
    }

    public YarnCluster getCluster(ClusterInfo clusterInfo) {
        YarnCluster cluster = this.clusters.get(clusterInfo);
        if (cluster == null) {
            log.info((Object)("Building new cluster for ClusterInfo=" + clusterInfo));
            try {
                YarnClusterFactoryBean fb = new YarnClusterFactoryBean();
                fb.setClusterId("yarn-" + clusterInfo.hashCode());
                fb.setNodes(clusterInfo.getNumYarn());
                fb.setAutoStart(true);
                fb.afterPropertiesSet();
                cluster = fb.getObject();
                this.clusters.put(clusterInfo, cluster);
            }
            catch (Exception exception) {}
        } else {
            log.info((Object)("Found cached cluster for ClusterInfo=" + clusterInfo));
        }
        return cluster;
    }

    public boolean closeCluster(YarnCluster cluster) {
        for (Map.Entry<ClusterInfo, YarnCluster> entry : this.clusters.entrySet()) {
            if (!entry.getValue().equals(cluster)) continue;
            entry.getValue().stop();
            this.clusters.remove(entry.getKey());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.doClose();
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void registerShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                @Override
                public void run() {
                    YarnClusterManager.this.doClose();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void doClose() {
        for (Map.Entry<ClusterInfo, YarnCluster> entry : this.clusters.entrySet()) {
            entry.getValue().stop();
        }
        this.clusters.clear();
    }
}

