/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.test.support;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.springframework.yarn.test.context.YarnCluster;

public class StandaloneYarnCluster
implements YarnCluster {
    private static final Log log = LogFactory.getLog(StandaloneYarnCluster.class);
    private MiniYARNCluster yarnCluster = null;
    private MiniDFSCluster dfsCluster = null;
    private final String clusterName;
    private Configuration configuration;
    private final Object startupShutdownMonitor = new Object();
    private boolean started;
    private int nodes = 1;

    public StandaloneYarnCluster(String clusterName) {
        this.clusterName = clusterName;
    }

    public StandaloneYarnCluster(String clusterName, int nodes) {
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        log.info((Object)("Checking if cluster=" + this.clusterName + " needs to be started"));
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            Configuration.addDefaultResource((String)"shdp-site.xml");
            log.info((Object)("Starting cluster=" + this.clusterName));
            this.configuration = new YarnConfiguration();
            this.configuration.set("hdfs.minidfs.basedir", "target/" + this.clusterName + "-dfs");
            this.dfsCluster = new MiniDFSCluster.Builder(this.configuration).numDataNodes(this.nodes).build();
            this.yarnCluster = new MiniYARNCluster(this.clusterName, this.nodes, 1, 1);
            this.yarnCluster.init(this.configuration);
            this.yarnCluster.start();
            log.info((Object)("Started cluster=" + this.clusterName));
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        log.info((Object)("Checking if cluster=" + this.clusterName + " needs to be stopped"));
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            if (this.yarnCluster != null) {
                this.yarnCluster.stop();
                this.yarnCluster = null;
            }
            if (this.dfsCluster != null) {
                this.dfsCluster.shutdown();
                this.dfsCluster = null;
            }
            log.info((Object)("Stopped cluster=" + this.clusterName));
            this.started = false;
        }
    }

    @Override
    public File getYarnWorkDir() {
        return this.yarnCluster != null ? this.yarnCluster.getTestWorkDir() : null;
    }

    public void setNodes(int nodes) {
        this.nodes = nodes;
    }
}

