/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.flex.config.xml.ParsingUtils;
import org.springframework.flex.security.LoginMessageInterceptor;
import org.springframework.flex.security.PerClientAuthenticationInterceptor;
import org.springframework.flex.security.SecurityExceptionTranslator;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.util.AntUrlPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MessageBrokerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MESSAGE_BROKER_FACTORY_BEAN_CLASS_NAME = "org.springframework.flex.core.MessageBrokerFactoryBean";
    private static final String MESSAGE_BROKER_HANDLER_ADAPTER_CLASS_NAME = "org.springframework.flex.servlet.MessageBrokerHandlerAdapter";
    private static final String DEFAULT_HANDLER_MAPPING_CLASS_NAME = "org.springframework.web.servlet.handler.SimpleUrlHandlerMapping";
    private static final String LOGIN_COMMAND_CLASS_NAME = "org.springframework.flex.security.SpringSecurityLoginCommand";
    private static final String ENDPOINT_PROCESSOR_CLASS_NAME = "org.springframework.flex.core.EndpointConfigProcessor";
    private static final String EXCEPTION_TRANSLATION_CLASS_NAME = "org.springframework.flex.core.ExceptionTranslationAdvice";
    private static final String MESSAGE_INTERCEPTION_CLASS_NAME = "org.springframework.flex.core.MessageInterceptionAdvice";
    private static final String ENDPOINT_INTERCEPTOR_CLASS_NAME = "org.springframework.flex.security.EndpointInterceptor";
    private static final String SERVICE_MESSAGE_ADVISOR_CLASS_NAME = "org.springframework.flex.core.EndpointServiceMessagePointcutAdvisor";
    private static final String ENDPOINT_DEFINITION_SOURCE_CLASS_NAME = "org.springframework.flex.security.EndpointDefinitionSource";
    private static final String REMOTING_PROCESSOR_CLASS_NAME = "org.springframework.flex.remoting.RemotingServiceConfigProcessor";
    private static final String MESSAGING_PROCESSOR_CLASS_NAME = "org.springframework.flex.messaging.MessageServiceConfigProcessor";
    private static final String SESSION_FIXATION_CONFIGURER_CLASS_NAME = "org.springframework.flex.config.SessionFixationProtectionConfigurer";
    private static final String REMOTING_ANNOTATION_PROCESSOR_CLASS_NAME = "org.springframework.flex.config.RemotingAnnotationPostProcessor";
    private static final String CUSTOM_EDITOR_CONFIGURER_CLASS_NAME = "org.springframework.beans.factory.config.CustomEditorConfigurer";
    private static final String JSON_CONFIG_MAP_EDITOR_CLASS_NAME = "org.springframework.flex.config.json.JsonConfigMapPropertyEditor";
    private static final String CONFIG_MAP_CLASS_NAME = "flex.messaging.config.ConfigMap";
    private static final String CONFIGURATION_MANAGER_ATTR = "configuration-manager";
    private static final String SERVICES_CONFIG_PATH_ATTR = "services-config-path";
    private static final String MAPPING_ORDER_ATTR = "mapping-order";
    private static final String DISABLE_DEFAULT_MAPPING_ATTR = "disable-default-mapping";
    private static final String PATTERN_ATTR = "pattern";
    private static final String REF_ATTR = "ref";
    private static final String AUTH_MANAGER_ATTR = "authentication-manager";
    private static final String ACCESS_MANAGER_ATTR = "access-decision-manager";
    private static final String PER_CLIENT_AUTHENTICATION_ATTR = "per-client-authentication";
    private static final String ACCESS_ATTR = "access";
    private static final String CHANNEL_ATTR = "channel";
    private static final String URL_MAP_PROPERTY = "urlMap";
    private static final String ORDER_PROPERTY = "order";
    private static final String CONFIG_PROCESSORS_PROPERTY = "configProcessors";
    private static final String PER_CLIENT_AUTHENTICATION_PROPERTY = "perClientAuthentication";
    private static final String AUTH_MANAGER_PROPERTY = "authenticationManager";
    private static final String ACCESS_MANAGER_PROPERTY = "accessDecisionManager";
    private static final String OBJECT_DEF_SOURCE_PROPERTY = "objectDefinitionSource";
    private static final String EXCEPTION_TRANSLATORS_PROPERTY = "exceptionTranslators";
    private static final String MESSAGE_INTERCEPTORS_PROPERTY = "messageInterceptors";
    private static final String CUSTOM_EDITORS_PROPERTY = "customEditors";
    private static final String MAPPING_PATTERN_ELEMENT = "mapping";
    private static final String CONFIG_PROCESSOR_ELEMENT = "config-processor";
    private static final String EXCEPTION_TRANSLATOR_ELEMENT = "exception-translator";
    private static final String MESSAGE_INTERCEPTOR_ELEMENT = "message-interceptor";
    private static final String SECURED_ELEMENT = "secured";
    private static final String SECURED_CHANNEL_ELEMENT = "secured-channel";
    private static final String SECURED_ENDPOINT_PATH_ELEMENT = "secured-endpoint-path";
    private static final String REMOTING_SERVICE_ELEMENT = "remoting-service";
    private static final String MESSAGE_SERVICE_ELEMENT = "message-service";
    private static final String DEFAULT_MAPPING_PATH = "/*";

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        CompositeComponentDefinition componentDefinition = new CompositeComponentDefinition(element.getLocalName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(componentDefinition);
        Object source = parserContext.extractSource((Object)element);
        ManagedSet configProcessors = new ManagedSet();
        configProcessors.setSource(source);
        ManagedList advisors = new ManagedList();
        advisors.setSource(source);
        ManagedSet translators = new ManagedSet();
        translators.setSource(source);
        ManagedSet interceptors = new ManagedSet();
        interceptors.setSource(source);
        if (!StringUtils.hasText((String)element.getAttribute("id"))) {
            element.setAttribute("id", "_messageBroker");
        }
        this.validateMessageBroker(element, parserContext);
        ParsingUtils.mapOptionalAttributes(element, parserContext, builder, SERVICES_CONFIG_PATH_ATTR);
        ParsingUtils.mapOptionalBeanRefAttributes(element, builder, parserContext, CONFIGURATION_MANAGER_ATTR);
        this.registerHandlerAdapterIfNecessary(element, parserContext);
        if (!Boolean.parseBoolean(element.getAttribute(DISABLE_DEFAULT_MAPPING_ATTR))) {
            this.registerHandlerMappings(element, parserContext, DomUtils.getChildElementsByTagName((Element)element, (String)MAPPING_PATTERN_ELEMENT));
        }
        this.registerCustomConfigProcessors(parserContext, (Set)configProcessors, DomUtils.getChildElementsByTagName((Element)element, (String)CONFIG_PROCESSOR_ELEMENT));
        this.registerConfigMapEditorIfNecessary(element, parserContext);
        this.configureMessageService(element, parserContext, configProcessors, DomUtils.getChildElementByTagName((Element)element, (String)MESSAGE_SERVICE_ELEMENT));
        this.configureRemotingService(element, parserContext, configProcessors, DomUtils.getChildElementByTagName((Element)element, (String)REMOTING_SERVICE_ELEMENT));
        this.registerExceptionTranslation(element, parserContext, advisors, translators, DomUtils.getChildElementsByTagName((Element)element, (String)EXCEPTION_TRANSLATOR_ELEMENT));
        this.registerMessageInterception(element, parserContext, advisors, interceptors, DomUtils.getChildElementsByTagName((Element)element, (String)MESSAGE_INTERCEPTOR_ELEMENT));
        this.configureSecurity(element, parserContext, configProcessors, advisors, translators, interceptors, DomUtils.getChildElementByTagName((Element)element, (String)SECURED_ELEMENT));
        this.registerEndpointProcessor(parserContext, configProcessors, advisors, element, element.getAttribute("id"));
        if (!configProcessors.isEmpty()) {
            builder.addPropertyValue(CONFIG_PROCESSORS_PROPERTY, (Object)configProcessors);
        }
        parserContext.popAndRegisterContainingComponent();
    }

    protected String getBeanClassName(Element element) {
        return MESSAGE_BROKER_FACTORY_BEAN_CLASS_NAME;
    }

    private void configureMessageService(Element parent, ParserContext parserContext, ManagedSet configProcessors, Element messageServiceElement) {
        Element source = messageServiceElement != null ? messageServiceElement : parent;
        BeanDefinitionBuilder messagingProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MESSAGING_PROCESSOR_CLASS_NAME);
        if (messageServiceElement != null) {
            ParsingUtils.mapAllAttributes(messageServiceElement, parserContext, messagingProcessorBuilder);
        }
        String brokerId = parent.getAttribute("id");
        ParsingUtils.registerInfrastructureComponent(source, parserContext, messagingProcessorBuilder, String.valueOf(brokerId) + "MessagingProcessor");
        configProcessors.add((Object)new RuntimeBeanReference(String.valueOf(brokerId) + "MessagingProcessor"));
        this.registerFlexRemotingAnnotationPostProcessorIfNecessary(source, parserContext);
    }

    private void configureRemotingService(Element parent, ParserContext parserContext, ManagedSet configProcessors, Element remotingServiceElement) {
        Element source = remotingServiceElement != null ? remotingServiceElement : parent;
        BeanDefinitionBuilder remotingProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)REMOTING_PROCESSOR_CLASS_NAME);
        if (remotingServiceElement != null) {
            ParsingUtils.mapAllAttributes(remotingServiceElement, parserContext, remotingProcessorBuilder);
        }
        String brokerId = parent.getAttribute("id");
        ParsingUtils.registerInfrastructureComponent(source, parserContext, remotingProcessorBuilder, String.valueOf(brokerId) + "RemotingProcessor");
        configProcessors.add((Object)new RuntimeBeanReference(String.valueOf(brokerId) + "RemotingProcessor"));
        this.registerFlexRemotingAnnotationPostProcessorIfNecessary(source, parserContext);
    }

    private void configureSecurity(Element parent, ParserContext parserContext, ManagedSet configProcessors, ManagedList advisors, ManagedSet translators, ManagedSet interceptors, Element securedElement) {
        String accessManager;
        if (securedElement == null) {
            return;
        }
        boolean perClientAuthentication = Boolean.parseBoolean(securedElement.getAttribute(PER_CLIENT_AUTHENTICATION_ATTR));
        String authManager = securedElement.getAttribute(AUTH_MANAGER_ATTR);
        if (!StringUtils.hasText((String)authManager)) {
            authManager = "_authenticationManager";
        }
        if (!StringUtils.hasText((String)(accessManager = securedElement.getAttribute(ACCESS_MANAGER_ATTR)))) {
            accessManager = "_accessManager";
        }
        this.registerAuthenticationListenerIfNecessary(securedElement, parserContext);
        String brokerId = parent.getAttribute("id");
        this.registerLoginCommand(brokerId, parserContext, configProcessors, securedElement, authManager, perClientAuthentication);
        translators.add((Object)new SecurityExceptionTranslator());
        if (perClientAuthentication) {
            interceptors.add((Object)new PerClientAuthenticationInterceptor());
        }
        interceptors.add((Object)new LoginMessageInterceptor());
        this.registerEndpointInterceptorIfNecessary(securedElement, parserContext, interceptors, authManager, accessManager);
    }

    private Object parseConfigAttributeDefinition(String access) {
        if (StringUtils.hasText((String)access)) {
            return new ConfigAttributeDefinition(StringUtils.commaDelimitedListToStringArray((String)access));
        }
        return null;
    }

    private void registerAuthenticationListenerIfNecessary(Element securedElement, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_sessionFixationProtectionConfigurer")) {
            BeanDefinitionBuilder configurerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SESSION_FIXATION_CONFIGURER_CLASS_NAME);
            ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, configurerBuilder, "_sessionFixationProtectionConfigurer");
        }
    }

    private void registerConfigMapEditorIfNecessary(Element source, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_jsonConfigMapEditorConfigurer")) {
            BeanDefinitionBuilder configurerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)CUSTOM_EDITOR_CONFIGURER_CLASS_NAME);
            ManagedMap editors = new ManagedMap();
            editors.put((Object)CONFIG_MAP_CLASS_NAME, (Object)JSON_CONFIG_MAP_EDITOR_CLASS_NAME);
            configurerBuilder.addPropertyValue(CUSTOM_EDITORS_PROPERTY, (Object)editors);
            ParsingUtils.registerInfrastructureComponent(source, parserContext, configurerBuilder, "_jsonConfigMapEditorConfigurer");
        }
    }

    private void registerCustomConfigProcessors(ParserContext parserContext, Set configProcessors, List configProcessorElements) {
        if (!CollectionUtils.isEmpty((Collection)configProcessorElements)) {
            for (Element configProcessorElement : configProcessorElements) {
                configProcessors.add(new RuntimeBeanReference(configProcessorElement.getAttribute(REF_ATTR)));
            }
        }
    }

    private void registerEndpointInterceptorIfNecessary(Element securedElement, ParserContext parserContext, ManagedSet interceptors, String authManager, String accessManager) {
        if (securedElement.hasChildNodes()) {
            BeanDefinitionBuilder interceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)ENDPOINT_INTERCEPTOR_CLASS_NAME);
            interceptorBuilder.addPropertyReference(AUTH_MANAGER_PROPERTY, authManager);
            interceptorBuilder.addPropertyReference(ACCESS_MANAGER_PROPERTY, accessManager);
            BeanDefinitionBuilder endpointDefSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)ENDPOINT_DEFINITION_SOURCE_CLASS_NAME);
            HashMap<String, Object> endpointMap = new HashMap<String, Object>();
            List securedChannelElements = DomUtils.getChildElementsByTagName((Element)securedElement, (String)SECURED_CHANNEL_ELEMENT);
            if (!CollectionUtils.isEmpty((Collection)securedChannelElements)) {
                for (Element securedChannel : securedChannelElements) {
                    String access = securedChannel.getAttribute(ACCESS_ATTR);
                    String channel = securedChannel.getAttribute(CHANNEL_ATTR);
                    Object attributeDefinition = this.parseConfigAttributeDefinition(access);
                    endpointMap.put(channel, attributeDefinition);
                }
            }
            LinkedHashMap<RequestKey, Object> requestMap = new LinkedHashMap<RequestKey, Object>();
            List securedEndpointPathElements = DomUtils.getChildElementsByTagName((Element)securedElement, (String)SECURED_ENDPOINT_PATH_ELEMENT);
            if (!CollectionUtils.isEmpty((Collection)securedEndpointPathElements)) {
                for (Element securedPath : securedEndpointPathElements) {
                    String access = securedPath.getAttribute(ACCESS_ATTR);
                    RequestKey pattern = new RequestKey(securedPath.getAttribute(PATTERN_ATTR));
                    Object attributeDefinition = this.parseConfigAttributeDefinition(access);
                    requestMap.put(pattern, attributeDefinition);
                }
            }
            endpointDefSourceBuilder.addConstructorArgValue((Object)new AntUrlPathMatcher());
            endpointDefSourceBuilder.addConstructorArgValue(requestMap);
            endpointDefSourceBuilder.addConstructorArgValue(endpointMap);
            String endpointDefSourceId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, endpointDefSourceBuilder);
            interceptorBuilder.addPropertyReference(OBJECT_DEF_SOURCE_PROPERTY, endpointDefSourceId);
            String interceptorId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, interceptorBuilder);
            interceptors.add((Object)new RuntimeBeanReference(interceptorId));
        }
    }

    private void registerEndpointProcessor(ParserContext parserContext, ManagedSet configProcessors, ManagedList advisors, Element securedElement, String brokerId) {
        BeanDefinitionBuilder endpointProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)ENDPOINT_PROCESSOR_CLASS_NAME);
        endpointProcessorBuilder.addConstructorArgValue((Object)advisors);
        ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, endpointProcessorBuilder, String.valueOf(brokerId) + "EndpointProcessor");
        configProcessors.add((Object)new RuntimeBeanReference(String.valueOf(brokerId) + "EndpointProcessor"));
    }

    private void registerExceptionTranslation(Element element, ParserContext parserContext, ManagedList advisors, ManagedSet translators, List exceptionTranslatorElements) {
        if (!CollectionUtils.isEmpty((Collection)exceptionTranslatorElements)) {
            for (Element exceptionTranslatorElement : exceptionTranslatorElements) {
                translators.add((Object)new RuntimeBeanReference(exceptionTranslatorElement.getAttribute(REF_ATTR)));
            }
        }
        BeanDefinitionBuilder advisorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SERVICE_MESSAGE_ADVISOR_CLASS_NAME);
        BeanDefinitionBuilder exceptionTranslationBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)EXCEPTION_TRANSLATION_CLASS_NAME);
        exceptionTranslationBuilder.addPropertyValue(EXCEPTION_TRANSLATORS_PROPERTY, (Object)translators);
        String exceptionTranslationId = ParsingUtils.registerInfrastructureComponent(element, parserContext, exceptionTranslationBuilder);
        advisorBuilder.addConstructorArgReference(exceptionTranslationId);
        String advisorId = ParsingUtils.registerInfrastructureComponent(element, parserContext, advisorBuilder);
        advisors.add((Object)new RuntimeBeanReference(advisorId));
    }

    private void registerFlexRemotingAnnotationPostProcessorIfNecessary(Element source, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_flexRemotingAnnotationPostProcessor")) {
            BeanDefinitionBuilder processorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)REMOTING_ANNOTATION_PROCESSOR_CLASS_NAME);
            ParsingUtils.registerInfrastructureComponent(source, parserContext, processorBuilder, "_flexRemotingAnnotationPostProcessor");
        }
    }

    private void registerHandlerAdapterIfNecessary(Element element, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_messageBrokerHandlerAdapter")) {
            BeanDefinitionBuilder handlerAdapterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MESSAGE_BROKER_HANDLER_ADAPTER_CLASS_NAME);
            ParsingUtils.registerInfrastructureComponent(element, parserContext, handlerAdapterBuilder, "_messageBrokerHandlerAdapter");
        }
    }

    private void registerHandlerMappings(Element parent, ParserContext parserContext, List mappingPatternElements) {
        BeanDefinitionBuilder handlerMappingBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DEFAULT_HANDLER_MAPPING_CLASS_NAME);
        if (StringUtils.hasText((String)parent.getAttribute(MAPPING_ORDER_ATTR))) {
            handlerMappingBuilder.addPropertyValue(ORDER_PROPERTY, (Object)Integer.parseInt(parent.getAttribute(MAPPING_ORDER_ATTR)));
        }
        HashMap<String, String> mappings = new HashMap<String, String>();
        if (CollectionUtils.isEmpty((Collection)mappingPatternElements)) {
            mappings.put(DEFAULT_MAPPING_PATH, parent.getAttribute("id"));
        } else {
            for (Element mappingElement : mappingPatternElements) {
                mappings.put(mappingElement.getAttribute(PATTERN_ATTR), parent.getAttribute("id"));
            }
        }
        handlerMappingBuilder.addPropertyValue(URL_MAP_PROPERTY, mappings);
        ParsingUtils.registerInfrastructureComponent(parent, parserContext, handlerMappingBuilder, String.valueOf(parent.getAttribute("id")) + "DefaultHandlerMapping");
    }

    private void registerLoginCommand(String brokerId, ParserContext parserContext, ManagedSet configProcessors, Element securedElement, String authManager, boolean perClientAuthentication) {
        String loginCommandId = String.valueOf(brokerId) + "LoginCommand";
        BeanDefinitionBuilder loginCommandBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)LOGIN_COMMAND_CLASS_NAME);
        loginCommandBuilder.addConstructorArgReference(authManager);
        loginCommandBuilder.addPropertyValue(PER_CLIENT_AUTHENTICATION_PROPERTY, (Object)perClientAuthentication);
        ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, loginCommandBuilder, loginCommandId);
        configProcessors.add((Object)new RuntimeBeanReference(loginCommandId));
    }

    private void registerMessageInterception(Element element, ParserContext parserContext, ManagedList advisors, ManagedSet interceptors, List messageInterceptorElements) {
        if (!CollectionUtils.isEmpty((Collection)messageInterceptorElements)) {
            for (Element messageProcessorElement : messageInterceptorElements) {
                interceptors.add((Object)new RuntimeBeanReference(messageProcessorElement.getAttribute(REF_ATTR)));
            }
        }
        BeanDefinitionBuilder advisorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SERVICE_MESSAGE_ADVISOR_CLASS_NAME);
        BeanDefinitionBuilder messageInterceptionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MESSAGE_INTERCEPTION_CLASS_NAME);
        messageInterceptionBuilder.addPropertyValue(MESSAGE_INTERCEPTORS_PROPERTY, (Object)interceptors);
        String messageInterceptionId = ParsingUtils.registerInfrastructureComponent(element, parserContext, messageInterceptionBuilder);
        advisorBuilder.addConstructorArgReference(messageInterceptionId);
        String advisorId = ParsingUtils.registerInfrastructureComponent(element, parserContext, advisorBuilder);
        advisors.add((Object)new RuntimeBeanReference(advisorId));
    }

    private void validateMessageBroker(Element element, ParserContext parserContext) {
        if (!"/WEB-INF/flex/services-config.xml".equals(element.getAttribute(SERVICES_CONFIG_PATH_ATTR)) && StringUtils.hasText((String)element.getAttribute(CONFIGURATION_MANAGER_ATTR))) {
            parserContext.getReaderContext().error("The services-config-path cannot be set when using a custom configuration-manager reference.  Set the configurationPath on the custom ConfigurationManager instead.", (Object)element);
        }
    }
}

