/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.messaging.MessageBroker;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.flex.config.MessageBrokerConfigProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractServiceConfigProcessor
implements MessageBrokerConfigProcessor,
BeanFactoryAware {
    private String defaultAdapterId = this.getServiceAdapterId();
    private String[] defaultChannels;
    private BeanFactory beanFactory;

    public MessageBroker processAfterStartup(MessageBroker broker) {
        Service service = broker.getServiceByType(this.getServiceClassName());
        Assert.notNull((Object)service, (String)("The MessageBroker with id '" + broker.getId() + "' does not have a service of type " + this.getServiceClassName() + " configured."));
        Assert.isTrue((boolean)service.isStarted(), (String)("The Service with id '" + service.getId() + "' of MessageBroker with id '" + broker.getId() + "' was not started as expected."));
        return broker;
    }

    public MessageBroker processBeforeStartup(MessageBroker broker) {
        Service service = broker.getServiceByType(this.getServiceClassName());
        if (service == null) {
            service = broker.createService(this.getServiceId(), this.getServiceClassName());
            if (this.getServiceAdapterId().equals(this.defaultAdapterId)) {
                service.registerAdapter(this.getServiceAdapterId(), this.getServiceAdapterClassName());
            } else {
                Assert.isAssignable(ServiceAdapter.class, (Class)this.beanFactory.getType(this.defaultAdapterId), (String)("A custom default adapter id must refer to a valid Spring bean that is a subclass of " + ServiceAdapter.class.getName() + ".  "));
                service.registerAdapter(this.defaultAdapterId, CustomSpringAdapter.class.getName());
            }
            service.setDefaultAdapter(this.defaultAdapterId);
            if (!ObjectUtils.isEmpty((Object[])this.defaultChannels)) {
                this.addDefaultChannels(broker, service);
            } else {
                this.findDefaultChannel(broker, service);
            }
        }
        return broker;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setDefaultAdapterId(String defaultAdapterId) {
        this.defaultAdapterId = defaultAdapterId;
    }

    public void setDefaultChannels(String[] defaultChannels) {
        this.defaultChannels = StringUtils.trimArrayElements((String[])defaultChannels);
    }

    protected abstract void findDefaultChannel(MessageBroker var1, Service var2);

    protected abstract String getServiceAdapterClassName();

    protected abstract String getServiceAdapterId();

    protected abstract String getServiceClassName();

    protected abstract String getServiceId();

    private void addDefaultChannels(MessageBroker broker, Service service) {
        ArrayList<String> defaultChannelList = new ArrayList<String>();
        String[] stringArray = this.defaultChannels;
        int n = this.defaultChannels.length;
        int n2 = 0;
        while (n2 < n) {
            String channelId = stringArray[n2];
            Assert.isTrue((boolean)broker.getChannelIds().contains(channelId), (String)("The channel " + channelId + " is not known to the MessageBroker " + broker.getId() + " and cannot be set as a default channel" + " on the " + this.getServiceClassName()));
            defaultChannelList.add(channelId);
            ++n2;
        }
        service.setDefaultChannels(defaultChannelList);
    }

    protected static final class CustomSpringAdapter {
        public CustomSpringAdapter() {
            throw new UnsupportedOperationException("This adapter class should never be instantiated directly by BlazeDS.  It is only a placeholder to denote that a Spring-managed adapter should be injected when a Destination isinitialized.");
        }
    }
}

