/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.remoting;

import flex.messaging.MessageBroker;
import flex.messaging.endpoints.AMFEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.services.RemotingService;
import flex.messaging.services.Service;
import flex.messaging.services.remoting.adapters.JavaAdapter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.flex.core.AbstractServiceConfigProcessor;
import org.springframework.util.CollectionUtils;

public class RemotingServiceConfigProcessor
extends AbstractServiceConfigProcessor {
    private static final Log log = LogFactory.getLog(RemotingServiceConfigProcessor.class);

    public void findDefaultChannel(MessageBroker broker, Service service) {
        if (!CollectionUtils.isEmpty((Collection)broker.getDefaultChannels())) {
            return;
        }
        Iterator channels = broker.getChannelIds().iterator();
        while (channels.hasNext()) {
            Endpoint endpoint = broker.getEndpoint((String)channels.next());
            if (!(endpoint instanceof AMFEndpoint)) continue;
            service.addDefaultChannel(endpoint.getId());
            return;
        }
        log.warn((Object)"No appropriate default channels were detected for the RemotingService.  The channels must be explicitly set on any exported service.");
    }

    protected String getServiceAdapterClassName() {
        return JavaAdapter.class.getName();
    }

    protected String getServiceAdapterId() {
        return "java-object";
    }

    protected String getServiceClassName() {
        return RemotingService.class.getName();
    }

    protected String getServiceId() {
        return "remoting-service";
    }
}

