/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.util.HashMap;
import java.util.Map;
import org.springframework.flex.core.MessageInterceptor;
import org.springframework.flex.core.MessageProcessingContext;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginMessageInterceptor
implements MessageInterceptor {
    private static final String SUCCESS_MSG = "success";

    @Override
    public Message postProcess(MessageProcessingContext context, Message inputMessage, Message outputMessage) {
        if (inputMessage instanceof CommandMessage && ((CommandMessage)inputMessage).getOperation() == 8 && SUCCESS_MSG.equals(outputMessage.getBody())) {
            outputMessage.setBody(this.getAuthenticationResult());
        }
        return outputMessage;
    }

    @Override
    public Message preProcess(MessageProcessingContext context, Message inputMessage) {
        return inputMessage;
    }

    private Map<String, Object> getAuthenticationResult() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        HashMap<String, Object> authenticationResult = new HashMap<String, Object>();
        authenticationResult.put("name", authentication.getName());
        String[] authorities = new String[authentication.getAuthorities().length];
        int i = 0;
        while (i < authorities.length) {
            authorities[i] = authentication.getAuthorities()[i].getAuthority();
            ++i;
        }
        authenticationResult.put("authorities", authorities);
        return authenticationResult;
    }
}

