/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.flex.core.MessageInterceptor;
import org.springframework.flex.core.MessageProcessingContext;
import org.springframework.flex.security3.EndpointSecurityMetadataSource;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;

public class EndpointInterceptor
extends AbstractSecurityInterceptor
implements MessageInterceptor,
BeanFactoryAware {
    private static final String STATUS_TOKEN = "_enpointInterceptorStatusToken";
    private EndpointSecurityMetadataSource securityMetadataSource;
    private BeanFactory beanFactory;

    public void afterPropertiesSet() throws Exception {
        if (this.getAccessDecisionManager() == null) {
            this.setAccessDecisionManager((AccessDecisionManager)this.beanFactory.getBean(AccessDecisionManager.class));
        }
        super.afterPropertiesSet();
    }

    public EndpointSecurityMetadataSource getObjectDefinitionSource() {
        return this.securityMetadataSource;
    }

    public Class getSecureObjectClass() {
        return AbstractEndpoint.class;
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public Message postProcess(MessageProcessingContext context, Message inputMessage, Message outputMessage) {
        if (context.getAttributes().containsKey(STATUS_TOKEN)) {
            InterceptorStatusToken token = (InterceptorStatusToken)context.getAttributes().get(STATUS_TOKEN);
            return (Message)this.afterInvocation(token, outputMessage);
        }
        return outputMessage;
    }

    public Message preProcess(MessageProcessingContext context, Message inputMessage) {
        if (!this.isPassThroughCommand(inputMessage)) {
            InterceptorStatusToken token = this.beforeInvocation(context.getMessageTarget());
            context.getAttributes().put(STATUS_TOKEN, token);
        }
        return inputMessage;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setObjectDefinitionSource(EndpointSecurityMetadataSource newSource) {
        this.securityMetadataSource = newSource;
    }

    private boolean isPassThroughCommand(Message message) {
        if (message instanceof CommandMessage) {
            CommandMessage command = (CommandMessage)message;
            return command.getOperation() == 5 || command.getOperation() == 8;
        }
        return false;
    }
}

