/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import flex.messaging.endpoints.Endpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointSecurityMetadataSource
extends DefaultFilterInvocationSecurityMetadataSource {
    private Map<String, Collection<ConfigAttribute>> endpointMap = new HashMap<String, Collection<ConfigAttribute>>();

    public EndpointSecurityMetadataSource(UrlMatcher urlMatcher, LinkedHashMap<RequestKey, Collection<ConfigAttribute>> requestMap) {
        super(urlMatcher, requestMap);
    }

    public EndpointSecurityMetadataSource(UrlMatcher urlMatcher, LinkedHashMap<RequestKey, Collection<ConfigAttribute>> requestMap, HashMap<String, Collection<ConfigAttribute>> endpointMap) {
        super(urlMatcher, requestMap);
        Assert.notNull(endpointMap, (String)"endpointMap cannot be null");
        this.endpointMap = endpointMap;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be an Endpoint");
        }
        Endpoint endpoint = (Endpoint)object;
        Collection<ConfigAttribute> attributes = null;
        attributes = this.endpointMap.containsKey(endpoint.getId()) ? this.endpointMap.get(endpoint.getId()) : this.lookupAttributes(endpoint.getUrlForClient(), null);
        return attributes;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        Collection pathDefinitions = super.getAllConfigAttributes();
        ArrayList<ConfigAttribute> allDefinitions = new ArrayList<ConfigAttribute>();
        for (Collection<ConfigAttribute> attrValues : this.endpointMap.values()) {
            allDefinitions.addAll(attrValues);
        }
        allDefinitions.addAll(pathDefinitions);
        return Collections.unmodifiableCollection(allDefinitions);
    }

    public boolean supports(Class<?> clazz) {
        return Endpoint.class.isAssignableFrom(clazz);
    }
}

