/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.flex.security3.FlexSessionInvalidatingAuthenticationListener;
import org.springframework.flex.security3.SpringSecurityLoginCommand;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.web.filter.RequestContextFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFixationProtectionPostProcessor
implements BeanFactoryPostProcessor,
ApplicationEventPublisherAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final Log log = LogFactory.getLog(SessionFixationProtectionPostProcessor.class);
    private boolean processed = false;
    private ApplicationEventPublisher applicationEventPublisher = null;
    private final String filterChainProxyId = "org.springframework.security.filterChainProxy";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory.getBeanNamesForType(SpringSecurityLoginCommand.class).length > 0 && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, SessionFixationProtectionStrategy.class).length > 0) {
            beanFactory.registerSingleton("_flexSessionAuthenticationListener", (Object)new FlexSessionInvalidatingAuthenticationListener());
            beanFactory.registerSingleton("_requestContextFilter", (Object)new PriorityOrderedRequestContextFilter());
        } else {
            this.processed = true;
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.processed) {
            String[] authFilterBeans = event.getApplicationContext().getBeanNamesForType(UsernamePasswordAuthenticationFilter.class);
            int i = 0;
            while (i < authFilterBeans.length) {
                UsernamePasswordAuthenticationFilter filter = (UsernamePasswordAuthenticationFilter)event.getApplicationContext().getBean(authFilterBeans[i]);
                filter.setApplicationEventPublisher(this.applicationEventPublisher);
                ++i;
            }
            if (event.getApplicationContext().containsBean("org.springframework.security.filterChainProxy")) {
                FilterChainProxy proxy = (FilterChainProxy)event.getApplicationContext().getBean("org.springframework.security.filterChainProxy", FilterChainProxy.class);
                UrlMatcher matcher = proxy.getMatcher();
                Object compiledPath = matcher.compile(matcher.getUniversalMatchPattern());
                if (proxy.getFilterChainMap().containsKey(compiledPath)) {
                    ((List)proxy.getFilterChainMap().get(compiledPath)).add(0, (Filter)event.getApplicationContext().getBean("_requestContextFilter"));
                }
                this.processed = true;
            } else {
                log.warn((Object)"Spring Security filter chain could not be auto-detected.  You must install the RequestContextFilter or RequestContextListenermanually in order for the flex session fixation protection integration to function as expected.");
                return;
            }
        }
    }

    public static final class PriorityOrderedRequestContextFilter
    extends RequestContextFilter
    implements Ordered {
        private static final int order = Integer.MIN_VALUE;

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }
}

