/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.grpc.client.autoconfigure.GrpcClientProperties;
import org.springframework.grpc.client.GrpcChannelBuilderCustomizer;
import org.springframework.grpc.client.interceptor.DefaultDeadlineSetupClientInterceptor;
import org.springframework.util.unit.DataSize;

class ClientPropertiesChannelBuilderCustomizer<T extends ManagedChannelBuilder<T>>
implements GrpcChannelBuilderCustomizer<T> {
    private final GrpcClientProperties properties;

    ClientPropertiesChannelBuilderCustomizer(GrpcClientProperties properties) {
        this.properties = properties;
    }

    public void customize(String authority, T builder) {
        GrpcClientProperties.ChannelConfig channel = this.properties.getChannel(authority);
        PropertyMapper mapper = PropertyMapper.get();
        mapper.from((Object)channel.getUserAgent()).to(arg_0 -> builder.userAgent(arg_0));
        if (!authority.startsWith("unix:") && !authority.startsWith("in-process:")) {
            mapper.from((Object)channel.getDefaultLoadBalancingPolicy()).to(arg_0 -> builder.defaultLoadBalancingPolicy(arg_0));
        }
        mapper.from((Object)channel.getMaxInboundMessageSize()).asInt(DataSize::toBytes).to(arg_0 -> builder.maxInboundMessageSize(arg_0));
        mapper.from((Object)channel.getMaxInboundMetadataSize()).asInt(DataSize::toBytes).to(arg_0 -> builder.maxInboundMetadataSize(arg_0));
        mapper.from((Object)channel.getKeepAliveTime()).to(this.durationProperty((arg_0, arg_1) -> builder.keepAliveTime(arg_0, arg_1)));
        mapper.from((Object)channel.getKeepAliveTimeout()).to(this.durationProperty((arg_0, arg_1) -> builder.keepAliveTimeout(arg_0, arg_1)));
        mapper.from((Object)channel.getIdleTimeout()).to(this.durationProperty((arg_0, arg_1) -> builder.idleTimeout(arg_0, arg_1)));
        mapper.from((Object)channel.isKeepAliveWithoutCalls()).to(arg_0 -> builder.keepAliveWithoutCalls(arg_0));
        Map<String, Object> defaultServiceConfig = channel.extractServiceConfig();
        if (channel.getHealth().isEnabled()) {
            String serviceNameToCheck = channel.getHealth().getServiceName() != null ? channel.getHealth().getServiceName() : "";
            defaultServiceConfig.put("healthCheckConfig", Map.of("serviceName", serviceNameToCheck));
        }
        if (!defaultServiceConfig.isEmpty()) {
            builder.defaultServiceConfig(defaultServiceConfig);
        }
        if (channel.getDefaultDeadline() != null && channel.getDefaultDeadline().toMillis() > 0L) {
            builder.intercept(new ClientInterceptor[]{new DefaultDeadlineSetupClientInterceptor(channel.getDefaultDeadline())});
        }
    }

    Consumer<Duration> durationProperty(BiConsumer<Long, TimeUnit> setter) {
        return duration -> setter.accept(duration.toNanos(), TimeUnit.NANOSECONDS);
    }
}

