/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

final class ConfigurationPropertiesMapUtils {
    private static final String NUMBER = "[0-9]+";

    private ConfigurationPropertiesMapUtils() {
    }

    static Map<String, @Nullable Object> convertIntegerKeyedMapsToLists(Map<String, @Nullable Object> input) {
        HashMap<String, @Nullable Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            map.put(entry.getKey(), ConfigurationPropertiesMapUtils.extract(entry.getValue()));
        }
        return map;
    }

    private static @Nullable Object extract(@Nullable Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Map) {
            return ConfigurationPropertiesMapUtils.map((Map)input);
        }
        return input;
    }

    private static Object map(Map<String, @Nullable Object> input) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Object> list = new ArrayList<Object>();
        boolean maybeList = true;
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (maybeList && key.matches(NUMBER)) {
                int index = Integer.parseInt(key);
                while (index >= list.size()) {
                    list.add(null);
                }
                list.set(index, ConfigurationPropertiesMapUtils.extract(value));
                continue;
            }
            maybeList = false;
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    map.put(String.valueOf(i), list.get(i));
                }
                list.clear();
            }
            map.put(key, ConfigurationPropertiesMapUtils.extract(value));
        }
        if (list.size() > 0) {
            return list;
        }
        return map;
    }
}

