/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import java.util.ArrayList;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.grpc.client.autoconfigure.GrpcClientProperties;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.grpc.client.AbstractGrpcClientRegistrar;
import org.springframework.grpc.client.GrpcClientFactory;

class DefaultGrpcClientRegistrations
extends AbstractGrpcClientRegistrar {
    private final Environment environment;
    private final BeanFactory beanFactory;

    DefaultGrpcClientRegistrations(Environment environment, BeanFactory beanFactory) {
        this.environment = environment;
        this.beanFactory = beanFactory;
    }

    protected GrpcClientFactory.GrpcClientRegistrationSpec[] collect(AnnotationMetadata meta) {
        Binder binder = Binder.get((Environment)this.environment);
        boolean hasDefaultChannel = binder.bind("spring.grpc.client.default-channel", GrpcClientProperties.ChannelConfig.class).isBound();
        if (hasDefaultChannel) {
            ArrayList packages = new ArrayList();
            if (AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
                packages.addAll(AutoConfigurationPackages.get((BeanFactory)this.beanFactory));
            }
            GrpcClientProperties clientProperties = (GrpcClientProperties)binder.bind("spring.grpc.client", GrpcClientProperties.class).orElseGet(GrpcClientProperties::new);
            return new GrpcClientFactory.GrpcClientRegistrationSpec[]{GrpcClientFactory.GrpcClientRegistrationSpec.of((String)"default").factory(clientProperties.getDefaultStubFactory()).packages(packages.toArray(new String[0]))};
        }
        return new GrpcClientFactory.GrpcClientRegistrationSpec[0];
    }
}

