/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.grpc.client.autoconfigure.ChannelBuilderCustomizers;
import org.springframework.boot.grpc.client.autoconfigure.GrpcChannelFactoryCustomizer;
import org.springframework.boot.grpc.client.autoconfigure.GrpcClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.grpc.client.ChannelCredentialsProvider;
import org.springframework.grpc.client.ClientInterceptorFilter;
import org.springframework.grpc.client.ClientInterceptorsConfigurer;
import org.springframework.grpc.client.GrpcChannelBuilderCustomizer;
import org.springframework.grpc.client.GrpcChannelFactory;
import org.springframework.grpc.client.InProcessGrpcChannelFactory;
import org.springframework.grpc.client.NettyGrpcChannelFactory;
import org.springframework.grpc.client.ShadedNettyGrpcChannelFactory;
import org.springframework.grpc.client.VirtualTargets;

class GrpcChannelFactoryConfigurations {
    GrpcChannelFactoryConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={InProcessChannelBuilder.class})
    @ConditionalOnMissingBean(value={InProcessGrpcChannelFactory.class})
    @ConditionalOnProperty(prefix="spring.grpc.client.inprocess", name={"enabled"}, havingValue="true", matchIfMissing=true)
    static class InProcessChannelFactoryConfiguration {
        InProcessChannelFactoryConfiguration() {
        }

        @Bean
        InProcessGrpcChannelFactory inProcessGrpcChannelFactory(ChannelBuilderCustomizers channelBuilderCustomizers, ClientInterceptorsConfigurer interceptorsConfigurer, ObjectProvider<ClientInterceptorFilter> interceptorFilter, ObjectProvider<GrpcChannelFactoryCustomizer> channelFactoryCustomizers) {
            List<GrpcChannelBuilderCustomizer> inProcessBuilderCustomizers = List.of(channelBuilderCustomizers::customize);
            InProcessGrpcChannelFactory factory = new InProcessGrpcChannelFactory(inProcessBuilderCustomizers, interceptorsConfigurer);
            if (interceptorFilter != null) {
                factory.setInterceptorFilter((ClientInterceptorFilter)interceptorFilter.getIfAvailable(() -> null));
            }
            channelFactoryCustomizers.orderedStream().forEach(customizer -> customizer.customize((GrpcChannelFactory)factory));
            return factory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={io.grpc.Channel.class, NettyChannelBuilder.class})
    @ConditionalOnMissingBean(value={GrpcChannelFactory.class}, ignored={InProcessGrpcChannelFactory.class})
    @ConditionalOnProperty(prefix="spring.grpc.client.inprocess.", name={"exclusive"}, havingValue="false", matchIfMissing=true)
    @EnableConfigurationProperties(value={GrpcClientProperties.class})
    static class NettyChannelFactoryConfiguration {
        NettyChannelFactoryConfiguration() {
        }

        @Bean
        NettyGrpcChannelFactory nettyGrpcChannelFactory(GrpcClientProperties properties, ChannelBuilderCustomizers channelBuilderCustomizers, ClientInterceptorsConfigurer interceptorsConfigurer, ObjectProvider<GrpcChannelFactoryCustomizer> channelFactoryCustomizers, ChannelCredentialsProvider credentials) {
            List<GrpcChannelBuilderCustomizer> builderCustomizers = List.of(channelBuilderCustomizers::customize);
            NettyGrpcChannelFactory factory = new NettyGrpcChannelFactory(builderCustomizers, interceptorsConfigurer);
            factory.setCredentialsProvider(credentials);
            factory.setVirtualTargets((VirtualTargets)properties);
            channelFactoryCustomizers.orderedStream().forEach(customizer -> customizer.customize((GrpcChannelFactory)factory));
            return factory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Channel.class, io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder.class})
    @ConditionalOnMissingBean(value={GrpcChannelFactory.class}, ignored={InProcessGrpcChannelFactory.class})
    @ConditionalOnProperty(prefix="spring.grpc.client.inprocess.", name={"exclusive"}, havingValue="false", matchIfMissing=true)
    @EnableConfigurationProperties(value={GrpcClientProperties.class})
    static class ShadedNettyChannelFactoryConfiguration {
        ShadedNettyChannelFactoryConfiguration() {
        }

        @Bean
        ShadedNettyGrpcChannelFactory shadedNettyGrpcChannelFactory(GrpcClientProperties properties, ChannelBuilderCustomizers channelBuilderCustomizers, ClientInterceptorsConfigurer interceptorsConfigurer, ObjectProvider<GrpcChannelFactoryCustomizer> channelFactoryCustomizers, ChannelCredentialsProvider credentials) {
            List<GrpcChannelBuilderCustomizer> builderCustomizers = List.of(channelBuilderCustomizers::customize);
            ShadedNettyGrpcChannelFactory factory = new ShadedNettyGrpcChannelFactory(builderCustomizers, interceptorsConfigurer);
            factory.setCredentialsProvider(credentials);
            factory.setVirtualTargets((VirtualTargets)properties);
            channelFactoryCustomizers.orderedStream().forEach(customizer -> customizer.customize((GrpcChannelFactory)factory));
            return factory;
        }
    }
}

