/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannelBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.grpc.client.autoconfigure.ChannelBuilderCustomizers;
import org.springframework.boot.grpc.client.autoconfigure.ClientPropertiesChannelBuilderCustomizer;
import org.springframework.boot.grpc.client.autoconfigure.CompositeChannelFactoryAutoConfiguration;
import org.springframework.boot.grpc.client.autoconfigure.ConditionalOnGrpcClientEnabled;
import org.springframework.boot.grpc.client.autoconfigure.DefaultGrpcClientRegistrations;
import org.springframework.boot.grpc.client.autoconfigure.GrpcChannelFactoryConfigurations;
import org.springframework.boot.grpc.client.autoconfigure.GrpcClientProperties;
import org.springframework.boot.grpc.client.autoconfigure.GrpcCodecConfiguration;
import org.springframework.boot.grpc.client.autoconfigure.NamedChannelCredentialsProvider;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.grpc.client.ChannelCredentialsProvider;
import org.springframework.grpc.client.ClientInterceptorsConfigurer;
import org.springframework.grpc.client.CoroutineStubFactory;
import org.springframework.grpc.client.GrpcChannelBuilderCustomizer;
import org.springframework.grpc.client.GrpcClientFactory;

@AutoConfiguration(before={CompositeChannelFactoryAutoConfiguration.class})
@ConditionalOnGrpcClientEnabled
@EnableConfigurationProperties(value={GrpcClientProperties.class})
@Import(value={GrpcCodecConfiguration.class, GrpcChannelFactoryConfigurations.ShadedNettyChannelFactoryConfiguration.class, GrpcChannelFactoryConfigurations.NettyChannelFactoryConfiguration.class, GrpcChannelFactoryConfigurations.InProcessChannelFactoryConfiguration.class, ClientScanConfiguration.class})
public final class GrpcClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    ClientInterceptorsConfigurer clientInterceptorsConfigurer(ApplicationContext applicationContext) {
        return new ClientInterceptorsConfigurer(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={ChannelCredentialsProvider.class})
    NamedChannelCredentialsProvider channelCredentialsProvider(SslBundles bundles, GrpcClientProperties properties) {
        return new NamedChannelCredentialsProvider(bundles, properties);
    }

    @Bean
    <T extends ManagedChannelBuilder<T>> GrpcChannelBuilderCustomizer<T> clientPropertiesChannelCustomizer(GrpcClientProperties properties) {
        return new ClientPropertiesChannelBuilderCustomizer(properties);
    }

    @ConditionalOnBean(value={CompressorRegistry.class})
    @Bean
    <T extends ManagedChannelBuilder<T>> GrpcChannelBuilderCustomizer<T> compressionClientCustomizer(CompressorRegistry registry) {
        return (name, builder) -> builder.compressorRegistry(registry);
    }

    @ConditionalOnBean(value={DecompressorRegistry.class})
    @Bean
    <T extends ManagedChannelBuilder<T>> GrpcChannelBuilderCustomizer<T> decompressionClientCustomizer(DecompressorRegistry registry) {
        return (name, builder) -> builder.decompressorRegistry(registry);
    }

    @ConditionalOnMissingBean
    @Bean
    ChannelBuilderCustomizers channelBuilderCustomizers(ObjectProvider<GrpcChannelBuilderCustomizer<?>> customizers) {
        return new ChannelBuilderCustomizers(customizers.orderedStream().toList());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"io.grpc.kotlin.AbstractCoroutineStub"})
    static class GrpcClientCoroutineStubConfiguration {
        GrpcClientCoroutineStubConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        CoroutineStubFactory coroutineStubFactory() {
            return new CoroutineStubFactory();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={GrpcClientFactory.class})
    @Import(value={DefaultGrpcClientRegistrations.class})
    static class ClientScanConfiguration {
        ClientScanConfiguration() {
        }
    }
}

