/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.grpc.client.autoconfigure.ConfigurationPropertiesMapUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.grpc.client.BlockingStubFactory;
import org.springframework.grpc.client.NegotiationType;
import org.springframework.grpc.client.StubFactory;
import org.springframework.grpc.client.VirtualTargets;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="spring.grpc.client")
public class GrpcClientProperties
implements EnvironmentAware,
VirtualTargets {
    private final Map<String, ChannelConfig> channels = new HashMap<String, ChannelConfig>();
    private final ChannelConfig defaultChannel = new ChannelConfig();
    private Class<? extends StubFactory<?>> defaultStubFactory = BlockingStubFactory.class;
    private Environment environment;

    GrpcClientProperties() {
        this.defaultChannel.setAddress("static://localhost:9090");
        this.environment = new StandardEnvironment();
    }

    public Map<String, ChannelConfig> getChannels() {
        return this.channels;
    }

    public ChannelConfig getDefaultChannel() {
        return this.defaultChannel;
    }

    public Class<? extends StubFactory<?>> getDefaultStubFactory() {
        return this.defaultStubFactory;
    }

    public void setDefaultStubFactory(Class<? extends StubFactory<?>> defaultStubFactory) {
        this.defaultStubFactory = defaultStubFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public ChannelConfig getChannel(String name) {
        if ("default".equals(name)) {
            return this.defaultChannel;
        }
        ChannelConfig channel = this.channels.get(name);
        if (channel != null) {
            return channel;
        }
        channel = this.defaultChannel.copy();
        Object address = name;
        if (!name.contains(":/") && !name.startsWith("unix:")) {
            if (name.contains(":")) {
                address = "static://" + name;
            } else {
                address = this.defaultChannel.getAddress();
                if (!((String)address).contains(":/")) {
                    address = "static://" + (String)address;
                }
            }
        }
        channel.setAddress((String)address);
        return channel;
    }

    public String getTarget(String authority) {
        ChannelConfig channel = this.getChannel(authority);
        String address = channel.getAddress();
        if (address.startsWith("static:") || address.startsWith("tcp:")) {
            address = address.substring(address.indexOf(":") + 1).replaceFirst("/*", "");
        }
        return this.environment.resolvePlaceholders(address);
    }

    public static class ChannelConfig {
        private String address = "static://localhost:9090";
        private @Nullable Duration defaultDeadline;
        private String defaultLoadBalancingPolicy = "round_robin";
        private boolean enableKeepAlive;
        private final Health health = new Health();
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration idleTimeout = Duration.ofSeconds(20L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration keepAliveTime = Duration.ofMinutes(5L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration keepAliveTimeout = Duration.ofSeconds(20L);
        private boolean keepAliveWithoutCalls;
        private DataSize maxInboundMessageSize = DataSize.ofBytes((long)0x400000L);
        private DataSize maxInboundMetadataSize = DataSize.ofBytes((long)8192L);
        private NegotiationType negotiationType = NegotiationType.PLAINTEXT;
        private boolean secure = true;
        private final Map<String, Object> serviceConfig = new HashMap<String, Object>();
        private final Ssl ssl = new Ssl();
        private @Nullable String userAgent;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public @Nullable Duration getDefaultDeadline() {
            return this.defaultDeadline;
        }

        public void setDefaultDeadline(@Nullable Duration defaultDeadline) {
            this.defaultDeadline = defaultDeadline;
        }

        public String getDefaultLoadBalancingPolicy() {
            return this.defaultLoadBalancingPolicy;
        }

        public void setDefaultLoadBalancingPolicy(String defaultLoadBalancingPolicy) {
            this.defaultLoadBalancingPolicy = defaultLoadBalancingPolicy;
        }

        public boolean isEnableKeepAlive() {
            return this.enableKeepAlive;
        }

        public void setEnableKeepAlive(boolean enableKeepAlive) {
            this.enableKeepAlive = enableKeepAlive;
        }

        public Health getHealth() {
            return this.health;
        }

        public Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        public void setIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public void setKeepAliveTime(Duration keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public Duration getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public void setKeepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
        }

        public boolean isKeepAliveWithoutCalls() {
            return this.keepAliveWithoutCalls;
        }

        public void setKeepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
        }

        public DataSize getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
            this.setMaxInboundSize(maxInboundMessageSize, s -> {
                this.maxInboundMessageSize = s;
            }, "maxInboundMessageSize");
        }

        public DataSize getMaxInboundMetadataSize() {
            return this.maxInboundMetadataSize;
        }

        public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
            this.setMaxInboundSize(maxInboundMetadataSize, s -> {
                this.maxInboundMetadataSize = s;
            }, "maxInboundMetadataSize");
        }

        private void setMaxInboundSize(DataSize maxSize, Consumer<DataSize> setter, String propertyName) {
            if (maxSize != null && maxSize.toBytes() >= 0L) {
                setter.accept(maxSize);
            } else if (maxSize != null && maxSize.toBytes() == -1L) {
                setter.accept(DataSize.ofBytes((long)Integer.MAX_VALUE));
            } else {
                throw new IllegalArgumentException("Unsupported %s: %s".formatted(propertyName, maxSize));
            }
        }

        public NegotiationType getNegotiationType() {
            return this.negotiationType;
        }

        public void setNegotiationType(NegotiationType negotiationType) {
            this.negotiationType = negotiationType;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public Map<String, Object> getServiceConfig() {
            return this.serviceConfig;
        }

        public Ssl getSsl() {
            return this.ssl;
        }

        public @Nullable String getUserAgent() {
            return this.userAgent;
        }

        public void setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
        }

        ChannelConfig copy() {
            ChannelConfig copy = new ChannelConfig();
            copy.address = this.address;
            copy.defaultLoadBalancingPolicy = this.defaultLoadBalancingPolicy;
            copy.negotiationType = this.negotiationType;
            copy.enableKeepAlive = this.enableKeepAlive;
            copy.idleTimeout = this.idleTimeout;
            copy.keepAliveTime = this.keepAliveTime;
            copy.keepAliveTimeout = this.keepAliveTimeout;
            copy.keepAliveWithoutCalls = this.keepAliveWithoutCalls;
            copy.maxInboundMessageSize = this.maxInboundMessageSize;
            copy.maxInboundMetadataSize = this.maxInboundMetadataSize;
            copy.userAgent = this.userAgent;
            copy.defaultDeadline = this.defaultDeadline;
            copy.health.copyValuesFrom(this.getHealth());
            copy.ssl.copyValuesFrom(this.getSsl());
            copy.serviceConfig.putAll(this.serviceConfig);
            return copy;
        }

        public Map<String, Object> extractServiceConfig() {
            return ConfigurationPropertiesMapUtils.convertIntegerKeyedMapsToLists(this.getServiceConfig());
        }

        public static class Health {
            private boolean enabled;
            private @Nullable String serviceName;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public @Nullable String getServiceName() {
                return this.serviceName;
            }

            public void setServiceName(String serviceName) {
                this.serviceName = serviceName;
            }

            void copyValuesFrom(Health other) {
                this.enabled = other.enabled;
                this.serviceName = other.serviceName;
            }
        }

        public static class Ssl {
            private @Nullable Boolean enabled;
            private @Nullable String bundle;

            public @Nullable Boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(@Nullable Boolean enabled) {
                this.enabled = enabled;
            }

            public boolean determineEnabled() {
                return this.enabled != null ? this.enabled : this.bundle != null;
            }

            public @Nullable String getBundle() {
                return this.bundle;
            }

            public void setBundle(@Nullable String bundle) {
                this.bundle = bundle;
            }

            void copyValuesFrom(Ssl other) {
                this.enabled = other.enabled;
                this.bundle = other.bundle;
            }
        }
    }
}

