/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Codec.class})
class GrpcCodecConfiguration {
    GrpcCodecConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    CompressorRegistry compressorRegistry(ObjectProvider<Compressor> compressors) {
        if (compressors.stream().count() == 0L) {
            return CompressorRegistry.getDefaultInstance();
        }
        CompressorRegistry registry = CompressorRegistry.newEmptyInstance();
        compressors.orderedStream().forEachOrdered(arg_0 -> ((CompressorRegistry)registry).register(arg_0));
        return registry;
    }

    @Bean
    @ConditionalOnMissingBean
    DecompressorRegistry decompressorRegistry(ObjectProvider<Decompressor> decompressors) {
        if (decompressors.stream().count() == 0L) {
            return DecompressorRegistry.getDefaultInstance();
        }
        DecompressorRegistry registry = DecompressorRegistry.emptyInstance();
        for (Decompressor decompressor : decompressors.orderedStream().toList()) {
            registry = registry.with(decompressor, false);
        }
        return registry;
    }
}

