/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.TlsChannelCredentials;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.boot.grpc.client.autoconfigure.GrpcClientProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.grpc.client.ChannelCredentialsProvider;
import org.springframework.grpc.client.NegotiationType;
import org.springframework.grpc.internal.InsecureTrustManagerFactory;
import org.springframework.util.Assert;

class NamedChannelCredentialsProvider
implements ChannelCredentialsProvider {
    private final SslBundles bundles;
    private final GrpcClientProperties properties;

    NamedChannelCredentialsProvider(SslBundles bundles, GrpcClientProperties properties) {
        this.bundles = bundles;
        this.properties = properties;
    }

    public ChannelCredentials getChannelCredentials(String path) {
        GrpcClientProperties.ChannelConfig channel = this.properties.getChannel(path);
        boolean sslEnabled = channel.getSsl().determineEnabled();
        if (!sslEnabled && channel.getNegotiationType() == NegotiationType.PLAINTEXT) {
            return InsecureChannelCredentials.create();
        }
        if (sslEnabled) {
            String bundleName = channel.getSsl().getBundle();
            Assert.notNull((Object)bundleName, (String)"Bundle name must not be null when SSL is enabled");
            SslBundle bundle = this.bundles.getBundle(bundleName);
            TrustManagerFactory trustManagers = channel.isSecure() ? bundle.getManagers().getTrustManagerFactory() : InsecureTrustManagerFactory.INSTANCE;
            return TlsChannelCredentials.newBuilder().keyManager(bundle.getManagers().getKeyManagerFactory().getKeyManagers()).trustManager(trustManagers.getTrustManagers()).build();
        }
        if (channel.isSecure()) {
            return TlsChannelCredentials.create();
        }
        return TlsChannelCredentials.newBuilder().trustManager(InsecureTrustManagerFactory.INSTANCE.getTrustManagers()).build();
    }
}

