/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import io.grpc.ServerBuilder;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerProperties;
import org.springframework.util.unit.DataSize;

class DefaultServerFactoryPropertyMapper<T extends ServerBuilder<T>> {
    private final GrpcServerProperties properties;

    DefaultServerFactoryPropertyMapper(GrpcServerProperties properties) {
        this.properties = properties;
    }

    void customizeServerBuilder(T serverBuilder) {
        PropertyMapper map = PropertyMapper.get();
        this.customizeKeepAlive(serverBuilder, map);
        this.customizeInboundLimits(serverBuilder, map);
    }

    void customizeKeepAlive(T serverBuilder, PropertyMapper map) {
        GrpcServerProperties.KeepAlive keepAliveProps = this.properties.getKeepAlive();
        map.from((Object)keepAliveProps.getTime()).to(this.durationProperty((arg_0, arg_1) -> serverBuilder.keepAliveTime(arg_0, arg_1)));
        map.from((Object)keepAliveProps.getTimeout()).to(this.durationProperty((arg_0, arg_1) -> serverBuilder.keepAliveTimeout(arg_0, arg_1)));
        map.from((Object)keepAliveProps.getMaxIdle()).to(this.durationProperty((arg_0, arg_1) -> serverBuilder.maxConnectionIdle(arg_0, arg_1)));
        map.from((Object)keepAliveProps.getMaxAge()).to(this.durationProperty((arg_0, arg_1) -> serverBuilder.maxConnectionAge(arg_0, arg_1)));
        map.from((Object)keepAliveProps.getMaxAgeGrace()).to(this.durationProperty((arg_0, arg_1) -> serverBuilder.maxConnectionAgeGrace(arg_0, arg_1)));
        map.from((Object)keepAliveProps.getPermitTime()).to(this.durationProperty((arg_0, arg_1) -> serverBuilder.permitKeepAliveTime(arg_0, arg_1)));
        map.from((Object)keepAliveProps.isPermitWithoutCalls()).to(arg_0 -> serverBuilder.permitKeepAliveWithoutCalls(arg_0));
    }

    void customizeInboundLimits(T serverBuilder, PropertyMapper map) {
        map.from((Object)this.properties.getMaxInboundMessageSize()).asInt(DataSize::toBytes).to(arg_0 -> serverBuilder.maxInboundMessageSize(arg_0));
        map.from((Object)this.properties.getMaxInboundMetadataSize()).asInt(DataSize::toBytes).to(arg_0 -> serverBuilder.maxInboundMetadataSize(arg_0));
    }

    Consumer<Duration> durationProperty(BiConsumer<Long, TimeUnit> setter) {
        return duration -> setter.accept(duration.toNanos(), TimeUnit.NANOSECONDS);
    }
}

