/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerFactoryCustomizer;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerProperties;
import org.springframework.boot.grpc.server.autoconfigure.InProcessServerFactoryPropertyMapper;
import org.springframework.boot.grpc.server.autoconfigure.NettyServerFactoryPropertyMapper;
import org.springframework.boot.grpc.server.autoconfigure.ServerBuilderCustomizers;
import org.springframework.boot.grpc.server.autoconfigure.ShadedNettyServerFactoryPropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.grpc.server.GrpcServerFactory;
import org.springframework.grpc.server.InProcessGrpcServerFactory;
import org.springframework.grpc.server.NettyGrpcServerFactory;
import org.springframework.grpc.server.ServerBuilderCustomizer;
import org.springframework.grpc.server.ServerServiceDefinitionFilter;
import org.springframework.grpc.server.ShadedNettyGrpcServerFactory;
import org.springframework.grpc.server.lifecycle.GrpcServerLifecycle;
import org.springframework.grpc.server.service.GrpcServiceConfigurer;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;
import org.springframework.grpc.server.service.ServerInterceptorFilter;
import org.springframework.util.Assert;

class GrpcServerFactoryConfigurations {
    GrpcServerFactoryConfigurations() {
    }

    private static void applyServerFactoryCustomizers(ObjectProvider<GrpcServerFactoryCustomizer> customizers, GrpcServerFactory factory) {
        customizers.orderedStream().forEach(customizer -> customizer.customize(factory));
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={InProcessGrpcServerFactory.class})
    @ConditionalOnMissingBean(value={InProcessGrpcServerFactory.class})
    @ConditionalOnProperty(prefix="spring.grpc.server.inprocess", name={"name"})
    @EnableConfigurationProperties(value={GrpcServerProperties.class})
    static class InProcessServerFactoryConfiguration {
        InProcessServerFactoryConfiguration() {
        }

        @Bean
        InProcessGrpcServerFactory inProcessGrpcServerFactory(GrpcServerProperties properties, GrpcServiceDiscoverer serviceDiscoverer, GrpcServiceConfigurer serviceConfigurer, ServerBuilderCustomizers serverBuilderCustomizers, ObjectProvider<ServerInterceptorFilter> interceptorFilter, ObjectProvider<ServerServiceDefinitionFilter> serviceFilter, ObjectProvider<GrpcServerFactoryCustomizer> customizers) {
            InProcessServerFactoryPropertyMapper mapper = new InProcessServerFactoryPropertyMapper(properties);
            List<ServerBuilderCustomizer> builderCustomizers = List.of(mapper::customizeServerBuilder, serverBuilderCustomizers::customize);
            String inProcessName = Objects.requireNonNull(properties.getInprocess().getName(), "The InProcess name property must be set");
            InProcessGrpcServerFactory factory = new InProcessGrpcServerFactory(inProcessName, builderCustomizers);
            factory.setInterceptorFilter((ServerInterceptorFilter)interceptorFilter.getIfAvailable());
            factory.setServiceFilter((ServerServiceDefinitionFilter)serviceFilter.getIfAvailable());
            GrpcServerFactoryConfigurations.applyServerFactoryCustomizers(customizers, (GrpcServerFactory)factory);
            serviceDiscoverer.findServices().stream().map(serviceSpec -> serviceConfigurer.configure(serviceSpec, (GrpcServerFactory)factory)).forEach(arg_0 -> ((InProcessGrpcServerFactory)factory).addService(arg_0));
            return factory;
        }

        @ConditionalOnBean(value={InProcessGrpcServerFactory.class})
        @ConditionalOnMissingBean(name={"inProcessGrpcServerLifecycle"})
        @Bean
        GrpcServerLifecycle inProcessGrpcServerLifecycle(InProcessGrpcServerFactory factory, GrpcServerProperties properties, ApplicationEventPublisher eventPublisher) {
            return new GrpcServerLifecycle((GrpcServerFactory)factory, properties.getShutdownGracePeriod(), eventPublisher);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={io.grpc.netty.NettyServerBuilder.class})
    @ConditionalOnMissingBean(value={GrpcServerFactory.class}, ignored={InProcessGrpcServerFactory.class})
    @ConditionalOnProperty(prefix="spring.grpc.server.inprocess.", name={"exclusive"}, havingValue="false", matchIfMissing=true)
    @EnableConfigurationProperties(value={GrpcServerProperties.class})
    static class NettyServerFactoryConfiguration {
        NettyServerFactoryConfiguration() {
        }

        @Bean
        NettyGrpcServerFactory nettyGrpcServerFactory(GrpcServerProperties properties, GrpcServiceDiscoverer serviceDiscoverer, GrpcServiceConfigurer serviceConfigurer, ServerBuilderCustomizers serverBuilderCustomizers, SslBundles bundles, ObjectProvider<GrpcServerFactoryCustomizer> customizers) {
            NettyServerFactoryPropertyMapper mapper = new NettyServerFactoryPropertyMapper(properties);
            List<ServerBuilderCustomizer> builderCustomizers = List.of(mapper::customizeServerBuilder, serverBuilderCustomizers::customize);
            KeyManagerFactory keyManager = null;
            TrustManagerFactory trustManager = null;
            if (properties.getSsl().determineEnabled()) {
                String bundleName = properties.getSsl().getBundle();
                Assert.notNull((Object)bundleName, () -> "SSL bundleName must not be null");
                SslBundle bundle = bundles.getBundle(bundleName);
                keyManager = bundle.getManagers().getKeyManagerFactory();
                trustManager = properties.getSsl().isSecure() ? bundle.getManagers().getTrustManagerFactory() : io.netty.handler.ssl.util.InsecureTrustManagerFactory.INSTANCE;
            }
            NettyGrpcServerFactory factory = new NettyGrpcServerFactory(properties.determineAddress(), builderCustomizers, keyManager, trustManager, properties.getSsl().getClientAuth());
            GrpcServerFactoryConfigurations.applyServerFactoryCustomizers(customizers, (GrpcServerFactory)factory);
            serviceDiscoverer.findServices().stream().map(serviceSpec -> serviceConfigurer.configure(serviceSpec, (GrpcServerFactory)factory)).forEach(arg_0 -> ((NettyGrpcServerFactory)factory).addService(arg_0));
            return factory;
        }

        @ConditionalOnBean(value={NettyGrpcServerFactory.class})
        @ConditionalOnMissingBean(name={"nettyGrpcServerLifecycle"})
        @Bean
        GrpcServerLifecycle nettyGrpcServerLifecycle(NettyGrpcServerFactory factory, GrpcServerProperties properties, ApplicationEventPublisher eventPublisher) {
            return new GrpcServerLifecycle((GrpcServerFactory)factory, properties.getShutdownGracePeriod(), eventPublisher);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={NettyServerBuilder.class})
    @ConditionalOnMissingBean(value={GrpcServerFactory.class}, ignored={InProcessGrpcServerFactory.class})
    @ConditionalOnProperty(prefix="spring.grpc.server.inprocess.", name={"exclusive"}, havingValue="false", matchIfMissing=true)
    @EnableConfigurationProperties(value={GrpcServerProperties.class})
    static class ShadedNettyServerFactoryConfiguration {
        ShadedNettyServerFactoryConfiguration() {
        }

        @Bean
        ShadedNettyGrpcServerFactory shadedNettyGrpcServerFactory(GrpcServerProperties properties, GrpcServiceDiscoverer serviceDiscoverer, GrpcServiceConfigurer serviceConfigurer, ServerBuilderCustomizers serverBuilderCustomizers, SslBundles bundles, ObjectProvider<GrpcServerFactoryCustomizer> customizers) {
            ShadedNettyServerFactoryPropertyMapper mapper = new ShadedNettyServerFactoryPropertyMapper(properties);
            List<ServerBuilderCustomizer> builderCustomizers = List.of(mapper::customizeServerBuilder, serverBuilderCustomizers::customize);
            KeyManagerFactory keyManager = null;
            TrustManagerFactory trustManager = null;
            if (properties.getSsl().determineEnabled()) {
                String bundleName = properties.getSsl().getBundle();
                Assert.notNull((Object)bundleName, () -> "SSL bundleName must not be null");
                SslBundle bundle = bundles.getBundle(bundleName);
                keyManager = bundle.getManagers().getKeyManagerFactory();
                trustManager = properties.getSsl().isSecure() ? bundle.getManagers().getTrustManagerFactory() : InsecureTrustManagerFactory.INSTANCE;
            }
            ShadedNettyGrpcServerFactory factory = new ShadedNettyGrpcServerFactory(properties.determineAddress(), builderCustomizers, keyManager, trustManager, properties.getSsl().getClientAuth());
            GrpcServerFactoryConfigurations.applyServerFactoryCustomizers(customizers, (GrpcServerFactory)factory);
            serviceDiscoverer.findServices().stream().map(serviceSpec -> serviceConfigurer.configure(serviceSpec, (GrpcServerFactory)factory)).forEach(arg_0 -> ((ShadedNettyGrpcServerFactory)factory).addService(arg_0));
            return factory;
        }

        @ConditionalOnBean(value={ShadedNettyGrpcServerFactory.class})
        @ConditionalOnMissingBean(name={"shadedNettyGrpcServerLifecycle"})
        @Bean
        GrpcServerLifecycle shadedNettyGrpcServerLifecycle(ShadedNettyGrpcServerFactory factory, GrpcServerProperties properties, ApplicationEventPublisher eventPublisher) {
            return new GrpcServerLifecycle((GrpcServerFactory)factory, properties.getShutdownGracePeriod(), eventPublisher);
        }
    }
}

