/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure.health;

import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.HealthStatusManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.health.actuate.endpoint.HealthDescriptor;
import org.springframework.boot.health.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.health.actuate.endpoint.StatusAggregator;
import org.springframework.boot.health.contributor.Status;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.Assert;

public class ActuatorHealthAdapter {
    private static final String INVALID_INDICATOR_MSG = "Unable to determine health for '%s' - check that your configured health-indicator-paths point to available indicators";
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private final HealthStatusManager healthStatusManager;
    private final HealthEndpoint healthEndpoint;
    private final StatusAggregator statusAggregator;
    private final boolean updateOverallHealth;
    private final List<String> healthIndicatorPaths;

    protected ActuatorHealthAdapter(HealthStatusManager healthStatusManager, HealthEndpoint healthEndpoint, StatusAggregator statusAggregator, boolean updateOverallHealth, List<String> healthIndicatorPaths) {
        this.healthStatusManager = healthStatusManager;
        this.healthEndpoint = healthEndpoint;
        this.statusAggregator = statusAggregator;
        this.updateOverallHealth = updateOverallHealth;
        Assert.notEmpty(healthIndicatorPaths, () -> "at least one health indicator path is required");
        this.healthIndicatorPaths = healthIndicatorPaths;
    }

    protected void updateHealthStatus() {
        Set<Status> individualStatuses = this.updateIndicatorsHealthStatus();
        if (this.updateOverallHealth) {
            this.updateOverallHealthStatus(individualStatuses);
        }
    }

    protected Set<Status> updateIndicatorsHealthStatus() {
        HashSet<Status> statuses = new HashSet<Status>();
        this.healthIndicatorPaths.forEach(healthIndicatorPath -> {
            HealthDescriptor healthComponent = this.healthEndpoint.healthForPath(healthIndicatorPath.split("/"));
            if (healthComponent == null) {
                this.logger.warn(() -> INVALID_INDICATOR_MSG.formatted(healthIndicatorPath));
            } else {
                this.logger.trace(() -> "Actuator returned '%s' for indicator '%s'".formatted(healthComponent, healthIndicatorPath));
                Status actuatorStatus = healthComponent.getStatus();
                HealthCheckResponse.ServingStatus grpcStatus = this.toServingStatus(actuatorStatus.getCode());
                this.healthStatusManager.setStatus(healthIndicatorPath, grpcStatus);
                this.logger.trace(() -> "Updated gRPC health status to '%s' for service '%s'".formatted(grpcStatus, healthIndicatorPath));
                statuses.add(actuatorStatus);
            }
        });
        return statuses;
    }

    protected void updateOverallHealthStatus(Set<Status> individualStatuses) {
        Status overallActuatorStatus = this.statusAggregator.getAggregateStatus(individualStatuses);
        HealthCheckResponse.ServingStatus overallGrpcStatus = this.toServingStatus(overallActuatorStatus.getCode());
        this.logger.trace(() -> "Actuator aggregate status '%s' for overall health".formatted(overallActuatorStatus));
        this.healthStatusManager.setStatus("", overallGrpcStatus);
        this.logger.trace(() -> "Updated overall gRPC health status to '%s'".formatted(overallGrpcStatus));
    }

    protected HealthCheckResponse.ServingStatus toServingStatus(String actuatorHealthStatusCode) {
        return switch (actuatorHealthStatusCode) {
            case "UP" -> HealthCheckResponse.ServingStatus.SERVING;
            case "DOWN" -> HealthCheckResponse.ServingStatus.NOT_SERVING;
            case "OUT_OF_SERVICE" -> HealthCheckResponse.ServingStatus.NOT_SERVING;
            case "UNKNOWN" -> HealthCheckResponse.ServingStatus.UNKNOWN;
            default -> HealthCheckResponse.ServingStatus.UNKNOWN;
        };
    }
}

