/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure.security;

import io.grpc.BindableService;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnSpringGrpc;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerFactoryAutoConfiguration;
import org.springframework.boot.grpc.server.autoconfigure.security.GrpcSecurityAutoConfiguration;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.ConditionalOnIssuerLocationJwtDecoder;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.ConditionalOnPublicKeyJwtDecoder;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.OAuth2ResourceServerProperties;
import org.springframework.boot.security.oauth2.server.resource.autoconfigure.servlet.JwkSetUriJwtDecoderBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.grpc.server.GlobalServerInterceptor;
import org.springframework.grpc.server.security.AuthenticationProcessInterceptor;
import org.springframework.grpc.server.security.GrpcSecurity;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.SupplierJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.SpringOpaqueTokenIntrospector;
import org.springframework.util.CollectionUtils;

@AutoConfiguration(beforeName={"org.springframework.boot.security.autoconfigure.UserDetailsServiceAutoConfiguration"}, afterName={"org.springframework.boot.security.autoconfigure.SecurityAutoConfiguration", "org.springframework.boot.security.oauth2.server.resource.autoconfigure.servlet.OAuth2ResourceServerAutoConfiguration"}, after={GrpcSecurityAutoConfiguration.class, GrpcServerFactoryAutoConfiguration.class})
@EnableConfigurationProperties(value={OAuth2ResourceServerProperties.class})
@ConditionalOnSpringGrpc
@ConditionalOnClass(value={InMemoryClientRegistrationRepository.class, BearerTokenAuthenticationToken.class, ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={GrpcServerFactoryAutoConfiguration.GrpcServletConfiguration.class})
@ConditionalOnBean(value={BindableService.class, GrpcSecurityAutoConfiguration.class})
@Import(value={Oauth2ResourceServerConfiguration.JwtConfiguration.class, Oauth2ResourceServerConfiguration.OpaqueTokenConfiguration.class})
public final class OAuth2ResourceServerAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    static class OAuth2ResourceServerJwtConfiguration {
        OAuth2ResourceServerJwtConfiguration() {
        }

        private static class JwtConverterPropertiesCondition
        extends AnyNestedCondition {
            JwtConverterPropertiesCondition() {
                super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
            }

            @ConditionalOnProperty(prefix="spring.security.oauth2.resourceserver.jwt", name={"authorities-claim-name"})
            static class OnAuthoritiesClaimName {
                OnAuthoritiesClaimName() {
                }
            }

            @ConditionalOnProperty(prefix="spring.security.oauth2.resourceserver.jwt", name={"principal-claim-name"})
            static class OnPrincipalClaimName {
                OnPrincipalClaimName() {
                }
            }

            @ConditionalOnProperty(prefix="spring.security.oauth2.resourceserver.jwt", name={"authority-prefix"})
            static class OnAuthorityPrefix {
                OnAuthorityPrefix() {
                }
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={JwtAuthenticationConverter.class})
        @Conditional(value={JwtConverterPropertiesCondition.class})
        static class JwtConverterConfiguration {
            private final OAuth2ResourceServerProperties.Jwt properties;

            JwtConverterConfiguration(OAuth2ResourceServerProperties properties) {
                this.properties = properties.getJwt();
            }

            @Bean
            JwtAuthenticationConverter getJwtAuthenticationConverter() {
                JwtGrantedAuthoritiesConverter grantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
                PropertyMapper map = PropertyMapper.get();
                map.from((Object)this.properties.getAuthorityPrefix()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthorityPrefix(arg_0));
                map.from((Object)this.properties.getAuthoritiesClaimDelimiter()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthoritiesClaimDelimiter(arg_0));
                map.from((Object)this.properties.getAuthoritiesClaimName()).to(arg_0 -> ((JwtGrantedAuthoritiesConverter)grantedAuthoritiesConverter).setAuthoritiesClaimName(arg_0));
                JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
                map.from((Object)this.properties.getPrincipalClaimName()).to(arg_0 -> ((JwtAuthenticationConverter)jwtAuthenticationConverter).setPrincipalClaimName(arg_0));
                jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)grantedAuthoritiesConverter);
                return jwtAuthenticationConverter;
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={AuthenticationProcessInterceptor.class})
        static class OAuth2SecurityFilterChainConfiguration {
            OAuth2SecurityFilterChainConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={JwtDecoder.class})
            @GlobalServerInterceptor
            AuthenticationProcessInterceptor jwtAuthenticationProcessInterceptor(GrpcSecurity http) throws Exception {
                http.authorizeRequests(requests -> requests.allRequests().authenticated());
                http.oauth2ResourceServer(resourceServer -> resourceServer.jwt(Customizer.withDefaults()));
                return (AuthenticationProcessInterceptor)http.build();
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={JwtDecoder.class})
        static class JwtDecoderConfiguration {
            private final OAuth2ResourceServerProperties.Jwt properties;
            private final List<OAuth2TokenValidator<Jwt>> additionalValidators;

            JwtDecoderConfiguration(OAuth2ResourceServerProperties properties, ObjectProvider<OAuth2TokenValidator<Jwt>> additionalValidators) {
                this.properties = properties.getJwt();
                this.additionalValidators = additionalValidators.orderedStream().toList();
            }

            @Bean
            @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
            JwtDecoder blockingJwtDecoderByJwkKeySetUri(ObjectProvider<JwkSetUriJwtDecoderBuilderCustomizer> customizers) {
                NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder builder = NimbusJwtDecoder.withJwkSetUri((String)this.properties.getJwkSetUri()).jwsAlgorithms(this::jwsAlgorithms);
                customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
                NimbusJwtDecoder nimbusJwtDecoder = builder.build();
                String issuerUri = this.properties.getIssuerUri();
                OAuth2TokenValidator defaultValidator = issuerUri != null ? JwtValidators.createDefaultWithIssuer((String)issuerUri) : JwtValidators.createDefault();
                nimbusJwtDecoder.setJwtValidator(this.getValidators((OAuth2TokenValidator<Jwt>)defaultValidator));
                return nimbusJwtDecoder;
            }

            private void jwsAlgorithms(Set<SignatureAlgorithm> signatureAlgorithms) {
                for (String algorithm : this.properties.getJwsAlgorithms()) {
                    signatureAlgorithms.add(SignatureAlgorithm.from((String)algorithm));
                }
            }

            private OAuth2TokenValidator<Jwt> getValidators(OAuth2TokenValidator<Jwt> defaultValidator) {
                List audiences = this.properties.getAudiences();
                if (CollectionUtils.isEmpty((Collection)audiences) && this.additionalValidators.isEmpty()) {
                    return defaultValidator;
                }
                ArrayList<Object> validators = new ArrayList<Object>();
                validators.add(defaultValidator);
                if (!CollectionUtils.isEmpty((Collection)audiences)) {
                    validators.add(this.audValidator(audiences));
                }
                validators.addAll(this.additionalValidators);
                return new DelegatingOAuth2TokenValidator(validators);
            }

            private JwtClaimValidator<List<String>> audValidator(List<String> audiences) {
                return new JwtClaimValidator("aud", aud -> this.nullSafeDisjoint((List<String>)aud, audiences));
            }

            private boolean nullSafeDisjoint(List<String> c1, List<String> c2) {
                return c1 != null && !Collections.disjoint(c1, c2);
            }

            @Bean
            @ConditionalOnPublicKeyJwtDecoder
            JwtDecoder blockingJwtDecoderByPublicKeyValue() throws Exception {
                RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(this.getKeySpec(this.properties.readPublicKey())));
                NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withPublicKey((RSAPublicKey)publicKey).signatureAlgorithm(SignatureAlgorithm.from((String)this.exactlyOneAlgorithm())).build();
                jwtDecoder.setJwtValidator(this.getValidators((OAuth2TokenValidator<Jwt>)JwtValidators.createDefault()));
                return jwtDecoder;
            }

            private byte[] getKeySpec(String keyValue) {
                keyValue = keyValue.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
                return Base64.getMimeDecoder().decode(keyValue);
            }

            private String exactlyOneAlgorithm() {
                int count;
                List algorithms = this.properties.getJwsAlgorithms();
                int n = count = algorithms != null ? algorithms.size() : 0;
                if (count != 1) {
                    throw new IllegalStateException("Creating a JWT decoder using a public key requires exactly one JWS algorithm but " + count + " were configured");
                }
                return (String)algorithms.get(0);
            }

            @Bean
            @ConditionalOnIssuerLocationJwtDecoder
            SupplierJwtDecoder blockingJwtDecoderByIssuerUri(ObjectProvider<JwkSetUriJwtDecoderBuilderCustomizer> customizers) {
                return new SupplierJwtDecoder(() -> {
                    String issuerUri = this.properties.getIssuerUri();
                    NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder builder = NimbusJwtDecoder.withIssuerLocation((String)issuerUri);
                    customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
                    NimbusJwtDecoder jwtDecoder = builder.build();
                    jwtDecoder.setJwtValidator(this.getValidators((OAuth2TokenValidator<Jwt>)JwtValidators.createDefaultWithIssuer((String)issuerUri)));
                    return jwtDecoder;
                });
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class OAuth2ResourceServerOpaqueTokenConfiguration {
        OAuth2ResourceServerOpaqueTokenConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={AuthenticationProcessInterceptor.class})
        static class OAuth2SecurityFilterChainConfiguration {
            OAuth2SecurityFilterChainConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={OpaqueTokenIntrospector.class})
            @GlobalServerInterceptor
            AuthenticationProcessInterceptor opaqueTokenAuthenticationProcessInterceptor(GrpcSecurity http) throws Exception {
                http.authorizeRequests(requests -> requests.allRequests().authenticated());
                http.oauth2ResourceServer(resourceServer -> resourceServer.opaqueToken(Customizer.withDefaults()));
                return (AuthenticationProcessInterceptor)http.build();
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={OpaqueTokenIntrospector.class})
        static class OpaqueTokenIntrospectionClientConfiguration {
            OpaqueTokenIntrospectionClientConfiguration() {
            }

            @Bean
            @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.opaquetoken.introspection-uri"})
            SpringOpaqueTokenIntrospector blockingOpaqueTokenIntrospector(OAuth2ResourceServerProperties properties) {
                OAuth2ResourceServerProperties.Opaquetoken opaqueToken = properties.getOpaquetoken();
                return SpringOpaqueTokenIntrospector.withIntrospectionUri((String)opaqueToken.getIntrospectionUri()).clientId(opaqueToken.getClientId()).clientSecret(opaqueToken.getClientSecret()).build();
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class Oauth2ResourceServerConfiguration {
        Oauth2ResourceServerConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={OAuth2ResourceServerOpaqueTokenConfiguration.OpaqueTokenIntrospectionClientConfiguration.class, OAuth2ResourceServerOpaqueTokenConfiguration.OAuth2SecurityFilterChainConfiguration.class})
        static class OpaqueTokenConfiguration {
            OpaqueTokenConfiguration() {
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={JwtDecoder.class})
        @Import(value={OAuth2ResourceServerJwtConfiguration.JwtConverterConfiguration.class, OAuth2ResourceServerJwtConfiguration.JwtDecoderConfiguration.class, OAuth2ResourceServerJwtConfiguration.OAuth2SecurityFilterChainConfiguration.class})
        static class JwtConfiguration {
            JwtConfiguration() {
            }
        }
    }
}

