/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class GrpcSecurityInServletFailureAnalyzer
extends AbstractFailureAnalyzer<NoSuchBeanDefinitionException> {
    private static final String GRPC_SECURITY_PATH = "org.springframework.grpc.server.security.GrpcSecurity";
    private static final String GRPC_SERVLET_PATH = "io.grpc.servlet.jakarta.GrpcServlet";
    private final Environment environment;

    public GrpcSecurityInServletFailureAnalyzer(Environment environment) {
        this.environment = environment;
    }

    protected @Nullable FailureAnalysis analyze(Throwable rootFailure, NoSuchBeanDefinitionException cause) {
        if (!this.isMissingGrpcSecurity(cause) || !this.isActuallyServletMode()) {
            return null;
        }
        return new FailureAnalysis(this.getDescription(), this.getAction(), (Throwable)cause);
    }

    private boolean isMissingGrpcSecurity(NoSuchBeanDefinitionException ex) {
        Class type = ex.getBeanType();
        return type != null && GRPC_SECURITY_PATH.equals(type.getName());
    }

    private boolean isActuallyServletMode() {
        boolean servletOnClassPath = ClassUtils.isPresent((String)GRPC_SERVLET_PATH, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        if (!servletOnClassPath) {
            return false;
        }
        String servletPropertyName = "spring.grpc.server.servlet.enabled";
        return (Boolean)this.environment.getProperty(servletPropertyName, Boolean.class, (Object)true);
    }

    private String getDescription() {
        return "GrpcSecurity is not available because this application is running the gRPC server in servlet mode (GrpcServlet).\n";
    }

    private String getAction() {
        return "Configure security using the standard Spring Security servlet configuration (SecurityFilterChain / HttpSecurity).\n";
    }
}

