/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure.security;

import io.grpc.internal.GrpcUtil;
import java.util.concurrent.Executor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcNativeServer;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcServerEnabled;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcServletServer;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnSpringGrpc;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerExecutorProvider;
import org.springframework.boot.grpc.server.autoconfigure.exception.GrpcExceptionHandlerAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.grpc.server.GlobalServerInterceptor;
import org.springframework.grpc.server.exception.GrpcExceptionHandler;
import org.springframework.grpc.server.security.CoroutineSecurityContextInterceptor;
import org.springframework.grpc.server.security.GrpcSecurity;
import org.springframework.grpc.server.security.SecurityContextServerInterceptor;
import org.springframework.grpc.server.security.SecurityGrpcExceptionHandler;
import org.springframework.security.concurrent.DelegatingSecurityContextExecutor;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.authentication.configuration.EnableGlobalAuthentication;
import org.springframework.security.web.SecurityFilterChain;

@AutoConfiguration(before={GrpcExceptionHandlerAutoConfiguration.class}, afterName={"org.springframework.boot.security.autoconfigure.SecurityAutoConfiguration"})
@ConditionalOnSpringGrpc
@ConditionalOnClass(value={ObjectPostProcessor.class})
@ConditionalOnGrpcServerEnabled
@Import(value={ExceptionHandlerConfiguration.class, GrpcNativeSecurityConfigurerConfiguration.class, GrpcServletSecurityConfigurerConfiguration.class})
public final class GrpcSecurityAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"io.grpc.kotlin.CoroutineContextServerInterceptor"})
    static class GrpcClientCoroutineStubConfiguration {
        GrpcClientCoroutineStubConfiguration() {
        }

        @Bean
        @GlobalServerInterceptor
        @ConditionalOnMissingBean
        CoroutineSecurityContextInterceptor coroutineSecurityContextInterceptor() {
            return new CoroutineSecurityContextInterceptor();
        }
    }

    @ConditionalOnBean(value={SecurityFilterChain.class})
    @ConditionalOnGrpcServletServer
    @Configuration(proxyBeanMethods=false)
    static class GrpcServletSecurityConfigurerConfiguration {
        GrpcServletSecurityConfigurerConfiguration() {
        }

        @Bean
        @GlobalServerInterceptor
        SecurityContextServerInterceptor securityContextInterceptor() {
            return new SecurityContextServerInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean(value={GrpcServerExecutorProvider.class})
        GrpcServerExecutorProvider grpcServerExecutorProvider() {
            return () -> new DelegatingSecurityContextExecutor((Executor)GrpcUtil.SHARED_CHANNEL_EXECUTOR.create());
        }
    }

    @ConditionalOnGrpcNativeServer
    @Configuration(proxyBeanMethods=false)
    @EnableGlobalAuthentication
    static class GrpcNativeSecurityConfigurerConfiguration {
        GrpcNativeSecurityConfigurerConfiguration() {
        }

        @Bean
        GrpcSecurity grpcSecurity(ObjectPostProcessor<Object> objectPostProcessor, AuthenticationConfiguration authenticationConfiguration, ApplicationContext context) throws Exception {
            AuthenticationManagerBuilder authenticationManagerBuilder = authenticationConfiguration.authenticationManagerBuilder(objectPostProcessor, context);
            authenticationManagerBuilder.parentAuthenticationManager(authenticationConfiguration.getAuthenticationManager());
            return new GrpcSecurity(objectPostProcessor, authenticationManagerBuilder, context);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={AuthenticationConfiguration.class})
    static class ExceptionHandlerConfiguration {
        ExceptionHandlerConfiguration() {
        }

        @Bean
        GrpcExceptionHandler accessExceptionHandler() {
            return new SecurityGrpcExceptionHandler();
        }
    }
}

