/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.test.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.grpc.server.InProcessGrpcServerFactory;
import org.springframework.grpc.server.lifecycle.GrpcServerStartedEvent;
import org.springframework.util.Assert;

class ServerPortInfoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
ApplicationListener<GrpcServerStartedEvent> {
    private static final String PROPERTY_SOURCE_NAME = "grpc.server.ports";
    private @Nullable ConfigurableApplicationContext applicationContext;

    ServerPortInfoApplicationContextInitializer() {
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        applicationContext.addApplicationListener((ApplicationListener)this);
    }

    public void onApplicationEvent(GrpcServerStartedEvent event) {
        if (event.getSource().getFactory() instanceof InProcessGrpcServerFactory) {
            return;
        }
        String propertyName = "local.grpc.port";
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext must not be null");
        this.setPortProperty((ApplicationContext)this.applicationContext, propertyName, event.getPort());
    }

    private void setPortProperty(ApplicationContext context, String propertyName, int port) {
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)context;
            this.setPortProperty(configurableContext.getEnvironment(), propertyName, port);
        }
        if (context.getParent() != null) {
            this.setPortProperty(context.getParent(), propertyName, port);
        }
    }

    private void setPortProperty(ConfigurableEnvironment environment, String propertyName, int port) {
        MutablePropertySources sources = environment.getPropertySources();
        PropertySource source = sources.get(PROPERTY_SOURCE_NAME);
        if (source == null) {
            source = new MapPropertySource(PROPERTY_SOURCE_NAME, new HashMap());
            sources.addFirst(source);
        }
        ((Map)source.getSource()).put(propertyName, port);
    }
}

